/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public class IOUtilities {
    private static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static int getChecksumCRC32(InputStream inputStream) {
        CRC32 checksummer = new CRC32();
        CheckedInputStream in = null;
        try {
            try {
                in = new CheckedInputStream(inputStream, checksummer);
                IOUtils.copy((InputStream)in, (OutputStream)new NullOutputStream());
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return (int)checksummer.getValue();
    }

    public static String crc32ToString(int checksum) {
        char[] buf = new char[8];
        int w = checksum;
        int i = 0;
        int x = 7;
        while (i < 4) {
            buf[x--] = HEX_CHARACTERS[w & 0xF];
            buf[x--] = HEX_CHARACTERS[w >>> 4 & 0xF];
            w >>= 8;
            ++i;
        }
        return new String(buf);
    }
}

