/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.DataSet;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Database;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Experiment;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinReference;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Sample;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Sequence;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.Update;

public interface IProtDAO
extends BaseQuery {
    @Select(value="select * from experiments where perm_id = ?{1}")
    public Experiment tryToGetExperimentByPermID(String var1);

    @Select(value="insert into experiments (perm_id) values (?{1}) returning id")
    public long createExperiment(String var1);

    @Select(value="select * from samples where perm_id = ?{1}")
    public Sample tryToGetSampleByPermID(String var1);

    @Select(value="insert into samples (expe_id, perm_id) values (?{1}, ?{2}) returning id")
    public long createSample(long var1, String var3);

    @Select(value="select * from databases where name_and_version = ?{1}")
    public Database tryToGetDatabaseByName(String var1);

    @Select(value="insert into databases (name_and_version) values (?{1}) returning id")
    public long createDatabase(String var1);

    @Select(value="select * from data_sets where perm_id = ?{1}")
    public DataSet tryToGetDataSetByPermID(String var1);

    @Select(value="insert into data_sets (expe_id, perm_id, db_id) values (?{1}, ?{2}, ?{3}) returning id")
    public long createDataSet(long var1, String var3, long var4);

    @Update(value="insert into probability_fdr_mappings (dase_id, probability, false_discovery_rate) values (?{1}, ?{2}, ?{3})")
    public void createProbabilityToFDRMapping(long var1, double var3, double var5);

    @Select(value="insert into proteins (dase_id, probability) values (?{1}, ?{2}) returning id")
    public long createProtein(long var1, double var3);

    @Select(value="insert into peptides (prot_id, sequence, charge) values (?{1}, ?{2}, ?{3}) returning id")
    public long createPeptide(long var1, String var3, int var4);

    @Select(value="insert into modified_peptides (pept_id, nterm_mass, cterm_mass) values (?{1}, ?{2}, ?{3}) returning id")
    public long createModifiedPeptide(long var1, double var3, double var5);

    @Select(value="insert into modifications (mope_id, pos, mass) values (?{1}, ?{2}, ?{3}) returning id")
    public long createModification(long var1, int var3, double var4);

    @Select(value="select * from protein_references where accession_number = ?{1}")
    public ProteinReference tryToGetProteinReference(String var1);

    @Select(value="insert into protein_references (accession_number, description) values (?{1}, ?{2}) returning id")
    public long createProteinReference(String var1, String var2);

    @Update(value="update protein_references set description = ?{2} where id = ?{1}")
    public void updateProteinReferenceDescription(long var1, String var3);

    @Select(value="select * from sequences where prre_id = ?{1} and db_id = ?{2}")
    public List<Sequence> tryToGetSequencesByReferenceAndDatabase(long var1, long var3);

    @Select(value="insert into sequences (db_id, prre_id, amino_acid_sequence, checksum) values (?{1.databaseID}, ?{1.proteinReferenceID}, ?{1.sequence}, ?{1.checksum}) returning id")
    public long createSequence(Sequence var1);

    @Update(value="insert into identified_proteins (prot_id, sequ_id, coverage, is_primary) values (?{1}, ?{2}, ?{3}, ?{4})")
    public void createIdentifiedProtein(long var1, long var3, double var5, boolean var7);

    @Update(value="insert into abundances (prot_id, samp_id, value) values (?{1}, ?{2}, ?{3})")
    public void createAbundance(long var1, long var3, double var5);

    @Update(value="insert into modification_fractions (modi_id, samp_id, fraction) values (?{1}, ?{2}, ?{3})")
    public void createModificationFraction(long var1, long var3, double var5);
}

