/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.AminoAcidMass;

final class ModificationFraction {
    private final String sample;
    private final double fraction;
    private final AminoAcidMass aminoAcidMass;

    ModificationFraction(String sample, String value) {
        this.sample = sample;
        String[] parts = value.split(":");
        if (parts.length != 3) {
            throw this.exception(value, "Three parts separated by ':' expected.");
        }
        this.aminoAcidMass = new AminoAcidMass();
        try {
            this.aminoAcidMass.setPosition(Integer.parseInt(parts[0]));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception(value, "Position part isn't an integer number: " + parts[0]);
        }
        try {
            this.aminoAcidMass.setMass(Double.parseDouble(parts[1]));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception(value, "Mass part isn't a floating-point number: " + parts[1]);
        }
        try {
            this.fraction = Double.parseDouble(parts[2]);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exception(value, "Fraction part isn't a floating-point number: " + parts[2]);
        }
    }

    private IllegalArgumentException exception(String value, String message) {
        return new IllegalArgumentException("Peptide parameter value [" + value + "] for sample '" + this.sample + "' is invalid: " + message);
    }

    public String getSample() {
        return this.sample;
    }

    public AminoAcidMass getAminoAcidMass() {
        return this.aminoAcidMass;
    }

    public double getFraction() {
        return this.fraction;
    }
}

