/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.etlserver.proteomics.AbstractSampleHandler;
import ch.systemsx.cisd.openbis.etlserver.proteomics.IProtDAO;
import ch.systemsx.cisd.openbis.etlserver.proteomics.ModificationFraction;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Experiment;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import java.util.List;

class ModificationFractionHandler
extends AbstractSampleHandler {
    public ModificationFractionHandler(IEncapsulatedOpenBISService openbisService, IProtDAO dao, ExperimentIdentifier experimentIdentifier, Experiment experiment, String delimiter, boolean restrictedSampleResolving) {
        super(openbisService, dao, experimentIdentifier, experiment, delimiter, restrictedSampleResolving);
    }

    @Override
    protected void handleSample(String parameterName, ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample) {
    }

    public void addModificationFractions(String peptideSequence, long modID, List<ModificationFraction> modificationFractions) {
        for (ModificationFraction modificationFraction : modificationFractions) {
            Sample sample = this.getOrCreateSample(modificationFraction.getSample(), peptideSequence);
            double fraction = modificationFraction.getFraction();
            this.dao.createModificationFraction(modID, sample.getId(), fraction);
        }
    }

    private Sample getOrCreateSample(String sampleName, String peptideSequence) {
        AbstractSampleHandler.SampleOrError sampleOrError = this.getOrCreateSampleOrError(sampleName);
        if (sampleOrError.error != null) {
            throw new UserFailureException("Protein '" + peptideSequence + "' has modification for " + sampleOrError.error);
        }
        return sampleOrError.sample;
    }
}

