/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.etlserver.IDataSetUploader;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.etlserver.proteomics.ProtXMLLoader;
import ch.systemsx.cisd.openbis.etlserver.proteomics.ResultDataSetUploader;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinSummary;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class ProtXMLUploader
implements IDataSetUploader {
    private static final String VALIDATING_XML = "validating-xml";
    private static final String ASSUMING_EXTENDED_PROT_XML = "assuming-extended-prot-xml";
    private static final String MS_INJECTION_SAMPLE_DELIMITER = "delimiter_for_sample_resolving";
    private static final String RESTRICTED_SAMPLE_RESOLVING = "restricted_sample_resolving";
    private static final String DATABASE_ENGINE = "database.engine";
    private static final String DATABASE_URL_HOST_PART = "database.url-host-part";
    private static final String DATABASE_BASIC_NAME = "database.basic-name";
    private static final String DATABASE_KIND = "database.kind";
    private static final String DATABASE_OWNER = "database.owner";
    private static final String DATABASE_PASSWORD = "database.password";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ProtXMLUploader.class);
    private final ProtXMLLoader loader;
    private final IEncapsulatedOpenBISService openbisService;
    private final DataSource dataSource;
    private final boolean assumingExtendedProtXML;
    private final String msInjectionSampleDelimiter;
    private final boolean restrictedSampleResolving;
    private ResultDataSetUploader currentResultDataSetUploader;

    private static DataSource createDataSource(Properties properties) {
        DatabaseConfigurationContext context = new DatabaseConfigurationContext();
        context.setDatabaseEngineCode(properties.getProperty(DATABASE_ENGINE, "postgresql"));
        context.setUrlHostPart(properties.getProperty(DATABASE_URL_HOST_PART, ""));
        context.setBasicDatabaseName(properties.getProperty(DATABASE_BASIC_NAME, "proteomics"));
        context.setDatabaseKind(PropertyUtils.getMandatoryProperty((Properties)properties, (String)DATABASE_KIND));
        context.setOwner(properties.getProperty(DATABASE_OWNER, ""));
        context.setPassword(properties.getProperty(DATABASE_PASSWORD, ""));
        return context.getDataSource();
    }

    public ProtXMLUploader(Properties properties, IEncapsulatedOpenBISService openbisService) {
        this.dataSource = ProtXMLUploader.createDataSource(properties);
        this.openbisService = openbisService;
        this.assumingExtendedProtXML = PropertyUtils.getBoolean((Properties)properties, (String)ASSUMING_EXTENDED_PROT_XML, (boolean)false);
        this.msInjectionSampleDelimiter = properties.getProperty(MS_INJECTION_SAMPLE_DELIMITER, "~");
        this.restrictedSampleResolving = PropertyUtils.getBoolean((Properties)properties, (String)RESTRICTED_SAMPLE_RESOLVING, (boolean)true);
        this.loader = new ProtXMLLoader(PropertyUtils.getBoolean((Properties)properties, (String)VALIDATING_XML, (boolean)false));
    }

    public void upload(File dataSet, DataSetInformation dataSetInformation) {
        long time = System.currentTimeMillis();
        File protXMLFile = this.getProtXMLFile(dataSet);
        ProteinSummary summary = this.loader.readProtXML(protXMLFile);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)(String.valueOf(summary.getProteinGroups().size()) + " protein groups are successfully read from '" + protXMLFile + "' in " + (System.currentTimeMillis() - time) + " msec"));
        }
        time = System.currentTimeMillis();
        if (this.currentResultDataSetUploader != null) {
            throw new IllegalStateException("The previous transaction has been neither commited nor rollbacked.");
        }
        this.currentResultDataSetUploader = this.createUploader();
        this.currentResultDataSetUploader.upload(dataSetInformation, summary);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Feeding result database took " + (System.currentTimeMillis() - time) + " msec."));
        }
    }

    public void commit() {
        try {
            this.currentResultDataSetUploader.commit();
        }
        finally {
            this.currentResultDataSetUploader = null;
        }
    }

    public void rollback() {
        try {
            if (this.currentResultDataSetUploader != null) {
                this.currentResultDataSetUploader.rollback();
            }
        }
        finally {
            this.currentResultDataSetUploader = null;
        }
    }

    protected ResultDataSetUploader createUploader() {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        return new ResultDataSetUploader(connection, this.openbisService, this.assumingExtendedProtXML, this.msInjectionSampleDelimiter, this.restrictedSampleResolving);
    }

    private File getProtXMLFile(File dataSet) {
        File[] files;
        if (!dataSet.isDirectory()) {
            return dataSet;
        }
        File[] fileArray = files = dataSet.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("prot.xml")) {
                return file;
            }
            ++n2;
        }
        throw new UserFailureException("No *prot.xml file found in data set '" + dataSet + "'.");
    }
}

