/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto;

import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Occurrence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OccurrenceUtil {
    public static List<Occurrence> getCoverage(String protein, Collection<String> peptides) {
        ArrayList<Occurrence> list = new ArrayList<Occurrence>();
        List<Occurrence> sortedList = OccurrenceUtil.calcSortedOccurrences(protein, peptides);
        if (!sortedList.isEmpty()) {
            Occurrence current = sortedList.get(0);
            int i = 1;
            while (i < sortedList.size()) {
                String currentPeptide = current.getWord();
                Occurrence next = sortedList.get(i);
                int diff = next.getStartIndex() - current.getStartIndex();
                if (current.getWord().length() < diff) {
                    list.add(current);
                    current = next;
                } else if (current.getEndIndex() < next.getEndIndex()) {
                    String mergedPeptides = String.valueOf(currentPeptide.substring(0, diff)) + next.getWord();
                    current = new Occurrence(mergedPeptides, current.getStartIndex());
                }
                ++i;
            }
            list.add(current);
        }
        return list;
    }

    private static List<Occurrence> calcSortedOccurrences(String protein, Collection<String> peptides) {
        ArrayList<Occurrence> result = new ArrayList<Occurrence>();
        for (String word : peptides) {
            result.addAll(OccurrenceUtil.findAllOccurrences(protein, word));
        }
        Collections.sort(result);
        return result;
    }

    public static List<Occurrence> findAllOccurrences(String protein, String peptide) {
        int occurrenceIndex;
        ArrayList<Occurrence> result = new ArrayList<Occurrence>();
        int startIndex = 0;
        while ((occurrenceIndex = protein.indexOf(peptide, startIndex)) != -1) {
            result.add(new Occurrence(peptide, occurrenceIndex));
            startIndex = occurrenceIndex + 1;
        }
        Collections.sort(result);
        return result;
    }
}

