/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.AutoRescaleIntensityImageTransformerFactory;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.BitShiftingImageTransformerFactory;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ConvertToolImageTransformerFactory;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.IntensityRangeImageTransformerFactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ImageTransformationBuffer {
    private static final String PREDEFINED_TRANSFORMATIONS_CODE_PREFIX = "_";
    private final List<ImageTransformation> imageTransformations = new ArrayList<ImageTransformation>();

    public ImageTransformation append(ImageTransformation transformation) {
        this.appendAll(transformation);
        return transformation;
    }

    public void appendAll(ImageTransformation ... transformations) {
        ImageTransformation[] imageTransformationArray = transformations;
        int n = transformations.length;
        int n2 = 0;
        while (n2 < n) {
            ImageTransformation transformation = imageTransformationArray[n2];
            this.imageTransformations.add(transformation);
            ++n2;
        }
        this.ensureTransformationCodesUnique();
    }

    private Set<String> ensureTransformationCodesUnique() {
        HashSet<String> usedTransformationCodes = new HashSet<String>();
        for (ImageTransformation transformation : this.imageTransformations) {
            String code = transformation.getCode();
            if (usedTransformationCodes.contains(code)) {
                throw new IllegalArgumentException("Two transformations have the same code: " + code);
            }
            usedTransformationCodes.add(code);
        }
        return usedTransformationCodes;
    }

    private void ensureOnlyOneDefault() {
        ImageTransformation defaultTansf = null;
        for (ImageTransformation transformation : this.imageTransformations) {
            if (!transformation.isDefault()) continue;
            if (defaultTansf == null) {
                defaultTansf = transformation;
                continue;
            }
            throw ConfigurationFailureException.fromTemplate((String)"Only one image transformation can be default, but two were found: '%s' and '%s'.", (Object[])new Object[]{defaultTansf.getLabel(), transformation.getLabel()});
        }
    }

    public ImageTransformation[] getTransformations() {
        this.ensureTransformationCodesUnique();
        this.ensureOnlyOneDefault();
        return this.imageTransformations.toArray(new ImageTransformation[this.imageTransformations.size()]);
    }

    public ImageTransformation[] appendAllBitShiftsFor12BitGrayscale() {
        return this.appendAllAvailableGrayscaleBitShifts(12);
    }

    public ImageTransformation[] appendAllBitShiftsFor16BitGrayscale() {
        return this.appendAllAvailableGrayscaleBitShifts(16);
    }

    private ImageTransformation[] appendAllAvailableGrayscaleBitShifts(int totalNumberOfBits) {
        int transformationsNumber = totalNumberOfBits - 8 + 1;
        ImageTransformation[] transformations = new ImageTransformation[transformationsNumber];
        int i = 0;
        while (i < transformationsNumber) {
            transformations[i] = this.appendGrayscaleBitShifting(i);
            ++i;
        }
        return transformations;
    }

    public ImageTransformation appendGrayscaleBitShifting(int shiftBits) {
        return this.append(ImageTransformationBuffer.createGrayscaleBitShifting(shiftBits));
    }

    private static ImageTransformation createGrayscaleBitShifting(int shiftBits) {
        if (shiftBits < 0) {
            throw new IllegalArgumentException("Cannot create an image transformation which shifts by a negative number of bits");
        }
        String label = ImageTransformationBuffer.createBitShiftingTransformationLabel(shiftBits);
        String code = ImageTransformationBuffer.createBitShiftingTransformationCode(shiftBits);
        String description = ImageTransformationBuffer.createBitShiftingTransformationDescription(shiftBits);
        BitShiftingImageTransformerFactory factory = new BitShiftingImageTransformerFactory(shiftBits);
        return new ImageTransformation(code, label, description, factory);
    }

    private static String createBitShiftingTransformationCode(int shiftBits) {
        return "_BIT_SHIFTING_" + shiftBits;
    }

    private static String createBitShiftingTransformationDescription(int shiftBits) {
        return String.format("Shows a range of grayscale image colors by visualising only 8 consecutive bits from %d to %d. Useful for extracting information from 12 and 16 bit images.", shiftBits, shiftBits + 7);
    }

    private static String createBitShiftingTransformationLabel(int shiftBits) {
        return String.format("Show bits %d-%d", shiftBits, shiftBits + 7);
    }

    public ImageTransformation appendRescaleGrayscaleIntensity(int blackPointIntensity, int whitePointIntensity) {
        return this.appendRescaleGrayscaleIntensity(blackPointIntensity, whitePointIntensity, null);
    }

    public ImageTransformation appendRescaleGrayscaleIntensity(int blackPointIntensity, int whitePointIntensity, String userFriendlyLabelOrNull) {
        return this.append(ImageTransformationBuffer.createRescaleGrayscaleIntensity(blackPointIntensity, whitePointIntensity, userFriendlyLabelOrNull));
    }

    public static ImageTransformation createRescaleGrayscaleIntensity(int blackPointIntensity, int whitePointIntensity, String userFriendlyLabelOrNull) {
        if (blackPointIntensity > whitePointIntensity || blackPointIntensity < 0 || whitePointIntensity < 0) {
            throw new IllegalArgumentException(String.format("Cannot create an image transformation because the range of intensities is invalid: [%d, %d]", blackPointIntensity, whitePointIntensity));
        }
        String label = ImageTransformationBuffer.createIntensityRangeTransformationLabel(userFriendlyLabelOrNull);
        String code = ImageTransformationBuffer.createIntensityRangeTransformationCode(blackPointIntensity, whitePointIntensity);
        String description = ImageTransformationBuffer.createIntensityRangeTransformationDescription(blackPointIntensity, whitePointIntensity);
        IntensityRangeImageTransformerFactory factory = new IntensityRangeImageTransformerFactory(blackPointIntensity, whitePointIntensity);
        return new ImageTransformation(code, label, description, factory);
    }

    private static String createIntensityRangeTransformationCode(int blackPointIntensity, int whitePointIntensity) {
        return "_INTENSITY_LEVEL_" + blackPointIntensity + PREDEFINED_TRANSFORMATIONS_CODE_PREFIX + whitePointIntensity;
    }

    private static String createIntensityRangeTransformationDescription(int blackPointIntensity, int whitePointIntensity) {
        return String.format("Transforms grayscale image by converting intensities of its pixels which are in the range [%d, %d] to 8 bit color depth. The range of intensities is usually calculated by processing a series of 12 or 16 bit images, then the transformation becomes useful to compare these images with each other in 8 bit color depth, especially when they use only a small part of available intensities range.", blackPointIntensity, whitePointIntensity);
    }

    private static String createIntensityRangeTransformationLabel(String labelOrNull) {
        return labelOrNull != null ? labelOrNull : "Fixed rescaling";
    }

    public ImageTransformation appendAutoRescaleGrayscaleIntensity(float threshold) {
        return this.appendAutoRescaleGrayscaleIntensity(threshold, null);
    }

    public ImageTransformation appendAutoRescaleGrayscaleIntensity(float threshold, String userFriendlyLabelOrNull) {
        return this.append(ImageTransformationBuffer.createAutoRescaleGrayscaleIntensity(threshold, userFriendlyLabelOrNull));
    }

    private static ImageTransformation createAutoRescaleGrayscaleIntensity(float threshold, String userFriendlyLabelOrNull) {
        if (threshold < 0.0f || threshold > 1.0f) {
            throw new IllegalArgumentException("Invalid value of the threshold, should be between 0 and 1, but is: " + threshold);
        }
        String label = ImageTransformationBuffer.createAutoRescaleIntensityTransformationLabel(userFriendlyLabelOrNull, threshold);
        String code = ImageTransformationBuffer.createAutoRescaleIntensityTransformationCode(threshold);
        String description = ImageTransformationBuffer.createAutoRescaleIntensityTransformationDescription(threshold);
        AutoRescaleIntensityImageTransformerFactory factory = new AutoRescaleIntensityImageTransformerFactory(threshold);
        return new ImageTransformation(code, label, description, factory);
    }

    private static String createAutoRescaleIntensityTransformationCode(float threshold) {
        return "_AUTO_INTENSITY_LEVEL_" + threshold * 100.0f;
    }

    private static String createAutoRescaleIntensityTransformationDescription(float threshold) {
        return String.format("Creates a transformation which converts each single grayscale image to 8 bit color depth and rescales pixels intensities so that the darkest pixel will become black and the brightest will become white (threshold margin: %s).", new DecimalFormat("#.###").format(threshold));
    }

    @Private
    static String createAutoRescaleIntensityTransformationLabel(String labelOrNull, float threshold) {
        String thresholdPercentage = new DecimalFormat("##.#").format(threshold * 100.0f);
        return labelOrNull != null ? labelOrNull : String.format("Optimal (image, %s%% cut)", thresholdPercentage);
    }

    public ImageTransformation appendImageMagicConvert(String convertCliArguments) {
        return this.appendImageMagicConvert(convertCliArguments, null);
    }

    public ImageTransformation appendImageMagicConvert(String convertCliArguments, String userFriendlyLabelOrNull) {
        return this.append(ImageTransformationBuffer.createImageMagicConvert(convertCliArguments, this.generateUniqueConvertTransformationCode(), userFriendlyLabelOrNull));
    }

    private static ImageTransformation createImageMagicConvert(String convertCliArguments, String transformationCode, String userFriendlyLabelOrNull) {
        if (StringUtils.isBlank((String)convertCliArguments)) {
            throw new IllegalArgumentException("No argument has been specified for the 'convert' command");
        }
        if (StringUtils.isBlank((String)transformationCode)) {
            throw new IllegalArgumentException("Transformation has not been specified");
        }
        String label = ImageTransformationBuffer.createImageMagicConvertTransformationLabel(convertCliArguments, userFriendlyLabelOrNull);
        String description = ImageTransformationBuffer.createImageMagicConvertTransformationDescription(convertCliArguments);
        ConvertToolImageTransformerFactory factory = new ConvertToolImageTransformerFactory(convertCliArguments);
        return new ImageTransformation(transformationCode, label, description, (IImageTransformerFactory)factory);
    }

    private static String createImageMagicConvertTransformationDescription(String convertCliArguments) {
        return String.format("Transforms images with ImageMagic tool by calling: 'convert %s ...'", convertCliArguments);
    }

    private static String createImageMagicConvertTransformationLabel(String convertCliArguments, String labelOrNull) {
        return labelOrNull != null ? labelOrNull : String.format("Convert (%s)", convertCliArguments);
    }

    private String generateUniqueConvertTransformationCode() {
        int i = 1;
        Set<String> usedTransformationCodes = this.ensureTransformationCodesUnique();
        while (usedTransformationCodes.contains(ImageTransformationBuffer.getConvertTransformationCode(i))) {
            ++i;
        }
        return ImageTransformationBuffer.getConvertTransformationCode(i);
    }

    private static String getConvertTransformationCode(int seqNumber) {
        return "_CONVERT_" + seqNumber;
    }
}

