/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.shared;

import com.csvreader.CsvWriter;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CellomicsMDBMetadataReader {
    private final Database database;
    private HashMap<String, FeatureDefinition> featureTypesDescription;

    public CellomicsMDBMetadataReader(String mdbPath) throws IOException {
        this.database = Database.open((File)new File(mdbPath));
        this.initializeFeatureDescriptions();
    }

    public void writeAllMetadata(String dir) throws IOException {
        this.writeAllMetadata(new File(dir));
    }

    public void writeAllMetadata(File dir) throws IOException {
        this.writeEntities("asnPlate", new File(dir, "Plate.tsv"));
        this.writeFeatures("asnPlateFeature", "PlateID", new File(dir, "PlateFeature.tsv"));
        this.writeEntities("asnWell", new File(dir, "Well.tsv"));
        this.writeFeatures("asnWellFeature", "WellID", new File(dir, "WellFeature.tsv"));
        this.writeEntities("WField", new File(dir, "Field.tsv"));
        this.writeFeatures("WFieldFeature", "WFieldID", new File(dir, "FieldFeature.tsv"));
        this.writeEntities("Cell", new File(dir, "Cell.tsv"));
        this.writeFeatures("CellFeature", "CellID", new File(dir, "CellFeature.tsv"));
        this.writeFeatureDefinitions(new File(dir, "FeatureDefinitions.tsv"));
    }

    private void initializeFeatureDescriptions() throws IOException {
        this.featureTypesDescription = new HashMap();
        Table featureTypes = this.database.getTable("asnFeatureType");
        for (Map row : featureTypes) {
            String id = CellomicsMDBMetadataReader.getIDValue(row, "ID");
            this.featureTypesDescription.put(id, new FeatureDefinition(row));
        }
    }

    void writeEntities(String entityType, File f) throws IOException {
        CellomicsWriter cw = null;
        try {
            cw = new CellomicsWriter(f);
            Table entityTable = this.database.getTable(entityType);
            boolean firstRow = true;
            for (Map row : entityTable) {
                if (firstRow) {
                    for (String key : row.keySet()) {
                        cw.addIndexedField(key);
                    }
                    cw.writeHeaders();
                    firstRow = false;
                }
                Entity entity = new Entity(row);
                cw.writeEntity(entity);
            }
        }
        catch (Throwable throwable) {
            try {
                if (cw != null) {
                    cw.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (cw != null) {
                cw.close();
            }
        }
        catch (IOException iOException) {}
    }

    void writeFeatures(String featureType, String entityForeignKey, File file) throws IOException {
        CellomicsWriter cw = null;
        try {
            cw = new CellomicsWriter(file);
            Table features = this.database.getTable(featureType);
            cw.addIndexedField(entityForeignKey);
            cw.addIndexedField("Feature");
            cw.addIndexedField("Value");
            cw.writeHeaders();
            for (Map row : features) {
                Feature f = new Feature(row, entityForeignKey);
                cw.writeFeature(f);
            }
        }
        catch (Throwable throwable) {
            try {
                if (cw != null) {
                    cw.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (cw != null) {
                cw.close();
            }
        }
        catch (IOException iOException) {}
    }

    void writeFeatureDefinitions(File file) throws IOException {
        CellomicsWriter cw = null;
        try {
            cw = new CellomicsWriter(file);
            cw.addIndexedField("Definition");
            cw.addIndexedField("Note");
            cw.writeHeaders();
            for (FeatureDefinition fd : this.featureTypesDescription.values()) {
                cw.writeFeatureDefinition(fd);
            }
        }
        catch (Throwable throwable) {
            try {
                if (cw != null) {
                    cw.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (cw != null) {
                cw.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static String getIDValue(Map<String, Object> row, String idField) {
        return row.get(idField).toString();
    }

    private static Double getFeatureValue(Map<String, Object> feature) {
        return (Double)feature.get("valdbl");
    }

    private class CellomicsWriter {
        int indexesCount = 0;
        final HashMap<String, Integer> indexes = new HashMap();
        final CsvWriter csvWriter;
        final Writer outputStream;

        public CellomicsWriter(File f) throws IOException {
            this.outputStream = new FileWriter(f);
            this.csvWriter = new CsvWriter(this.outputStream, '\t');
        }

        void addIndexedField(String fieldName) {
            if (!this.indexes.containsKey(fieldName)) {
                this.indexes.put(fieldName, this.indexesCount++);
            }
        }

        void writeHeaders() throws IOException {
            int n = this.indexes.size();
            String[] headers = new String[n];
            for (Map.Entry<String, Integer> entry : this.indexes.entrySet()) {
                headers[entry.getValue().intValue()] = entry.getKey();
            }
            this.csvWriter.writeRecord(headers);
        }

        void writeEntity(Entity entity) throws IOException {
            int n = this.indexes.size();
            String[] row = new String[n];
            for (Map.Entry entry : entity.fields) {
                int index = this.indexes.get(entry.getKey());
                row[index] = (String)entry.getValue();
            }
            this.csvWriter.writeRecord(row);
        }

        void writeFeature(Feature feature) throws IOException {
            String[] row = new String[]{feature.entityId, feature.getFeatureDescription(), feature.value.toString()};
            this.csvWriter.writeRecord(row);
        }

        public void writeFeatureDefinition(FeatureDefinition fd) throws IOException {
            String[] row = new String[]{fd.description, fd.notes};
            this.csvWriter.writeRecord(row);
        }

        void close() throws IOException {
            this.outputStream.close();
        }
    }

    private static class Entity {
        private final String id;
        private final List<Map.Entry<String, String>> fields = new LinkedList<Map.Entry<String, String>>();

        Entity(Map<String, Object> row) {
            for (Map.Entry<String, Object> o : row.entrySet()) {
                this.put(o.getKey(), o.getValue() == null ? "" : o.getValue().toString());
            }
            this.id = CellomicsMDBMetadataReader.getIDValue(row, "ID");
        }

        void put(String key, String value) {
            this.fields.add(new AbstractMap.SimpleEntry<String, String>(key, value));
        }
    }

    private class Feature {
        private final Double value;
        private final String entityId;
        private final String featureTypeId;

        public Feature(Map<String, Object> row, String entityForeignKey) {
            this.featureTypeId = CellomicsMDBMetadataReader.getIDValue(row, "TypeID");
            this.entityId = CellomicsMDBMetadataReader.getIDValue(row, entityForeignKey);
            this.value = CellomicsMDBMetadataReader.getFeatureValue(row);
        }

        String getFeatureDescription() {
            return ((FeatureDefinition)CellomicsMDBMetadataReader.this.featureTypesDescription.get(this.featureTypeId)).description;
        }
    }

    private class FeatureDefinition {
        private String description;
        private String notes;

        public FeatureDefinition(Map<String, Object> row) {
            this.description = row.get("Description").toString();
            this.notes = row.get("Notes").toString();
        }
    }
}

