/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.v1.impl;

import ch.systemsx.cisd.cina.client.util.v1.ICinaUtilities;
import ch.systemsx.cisd.cina.client.util.v1.impl.AbstractCinaFacadeState;
import ch.systemsx.cisd.cina.client.util.v1.impl.AuthenticatedState;
import ch.systemsx.cisd.cina.client.util.v1.impl.UnauthenticatedState;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.DssComponent;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.DssServiceRpcFactory;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.OpenBisServiceFactory;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import java.util.List;

public class CinaUtilitiesFacade
implements ICinaUtilities {
    private final IGeneralInformationService generalInformationService;
    private final IServiceForDataStoreServer openbisService;
    private AbstractCinaFacadeState state;

    public static CinaUtilitiesFacade tryCreate(String user, String password, String openBISUrl, long timeoutInMillis) {
        CinaUtilitiesFacade component = CinaUtilitiesFacade.tryCreate(null, openBISUrl, timeoutInMillis);
        try {
            component.login(user, password, timeoutInMillis);
        }
        catch (AuthorizationFailureException authorizationFailureException) {
            return null;
        }
        return component;
    }

    public static CinaUtilitiesFacade tryCreate(String sessionToken, String openBISUrl, long timeoutInMillis) {
        IGeneralInformationService generalInfoService = CinaUtilitiesFacade.createGeneralInformationService(openBISUrl, timeoutInMillis);
        IServiceForDataStoreServer openbisService = CinaUtilitiesFacade.createOpenBisService(openBISUrl, timeoutInMillis);
        IDssComponent dssComponent = CinaUtilitiesFacade.createDssComponent(openbisService, generalInfoService, sessionToken, timeoutInMillis);
        return new CinaUtilitiesFacade(generalInfoService, openbisService, dssComponent, sessionToken);
    }

    private static IGeneralInformationService createGeneralInformationService(String openBISURL, long timeoutInMillis) {
        ServiceFinder generalInformationServiceFinder = new ServiceFinder("openbis", "/rmi-general-information-v1");
        IGeneralInformationService service = generalInformationServiceFinder.createService(IGeneralInformationService.class, openBISURL, timeoutInMillis);
        return service;
    }

    private static IServiceForDataStoreServer createOpenBisService(String openBISURL, long timeoutInMillis) {
        return new OpenBisServiceFactory(openBISURL, "/rmi-etl").createService(timeoutInMillis);
    }

    private static IDssComponent createDssComponent(IServiceForDataStoreServer openbisService, IGeneralInformationService generalInformationService, String sessionTokenOrNull, long timeoutInMillis) {
        return new DssComponent(generalInformationService, new DssServiceRpcFactory(timeoutInMillis), sessionTokenOrNull);
    }

    protected CinaUtilitiesFacade(IGeneralInformationService generalInformationService, IServiceForDataStoreServer openbisService, IDssComponent dssComponent, String sessionTokenOrNull) {
        this.generalInformationService = generalInformationService;
        this.openbisService = openbisService;
        this.state = sessionTokenOrNull == null ? new UnauthenticatedState(generalInformationService) : new AuthenticatedState(generalInformationService, openbisService, dssComponent, sessionTokenOrNull);
    }

    @Deprecated
    void loginForTesting(String user, String password, IDssComponent dssComponent) throws AuthorizationFailureException, EnvironmentFailureException {
        this.state.login(user, password);
        this.state = new AuthenticatedState(this.generalInformationService, this.openbisService, dssComponent, this.state.getSessionToken());
    }

    void login(String user, String password, long timeoutInMillis) throws AuthorizationFailureException, EnvironmentFailureException {
        this.state.login(user, password);
        this.state = new AuthenticatedState(this.generalInformationService, this.openbisService, CinaUtilitiesFacade.createDssComponent(this.openbisService, this.generalInformationService, this.state.getSessionToken(), timeoutInMillis), this.state.getSessionToken());
    }

    @Override
    public void logout() {
        this.state.logout();
        this.state = new UnauthenticatedState(this.generalInformationService);
    }

    @Override
    public String getSessionToken() throws IllegalStateException {
        return this.state.getSessionToken();
    }

    @Override
    public List<Sample> searchForSamples(SearchCriteria searchCriteria) throws IllegalStateException, EnvironmentFailureException {
        return this.state.searchForSamples(searchCriteria);
    }

    @Override
    public String generateSampleCode(String sampleTypeCode) throws IllegalStateException, EnvironmentFailureException {
        return this.state.generateSampleCode(sampleTypeCode);
    }

    @Override
    public List<Experiment> listVisibleExperiments(String experimentType) throws IllegalStateException, EnvironmentFailureException {
        return this.state.listVisibleExperiments(experimentType);
    }

    @Override
    public List<DataSet> listDataSets(List<Sample> samples) throws IllegalStateException, EnvironmentFailureException {
        return this.state.listDataSets(samples);
    }

    @Override
    public IDataSetDss getDataSet(String dataSetCode) throws IllegalStateException, EnvironmentFailureException, UserFailureException {
        return this.state.getDataSet(dataSetCode);
    }

    @Override
    public List<DataSet> listDataSetsForSample(Sample sample, boolean areOnlyDirectlyConnectedIncluded) throws IllegalStateException, EnvironmentFailureException, UserFailureException {
        return this.state.listDataSetsForSample(sample, areOnlyDirectlyConnectedIncluded);
    }
}

