/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.Id;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.SqlResultSetMapping;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Entity
@SqlResultSetMapping(name="dataset_access_implicit", entities={@EntityResult(entityClass=DataSetAccessPE.class)})
@NamedNativeQueries(value={@NamedNativeQuery(name="dataset_access", query="select g.code as spaceCode, dbi.uuid as databaseInstanceUuid, dbi.code as databaseInstanceCode from projects p, spaces g, database_instances dbi where p.id in (select e.proj_id from data ds, experiments e where ds.code in (:codes) and ds.expe_id = e.id group by e.proj_id) and p.space_id = g.id and dbi.id = g.dbin_id", resultSetMapping="dataset_access_implicit"), @NamedNativeQuery(name="deleted_dataset_access", query="select g.code as spaceCode, dbi.uuid as databaseInstanceUuid, dbi.code as databaseInstanceCode from projects p, spaces g, database_instances dbi where p.id in (select e.proj_id from data_deleted ds, experiments_all e where ds.del_id in (:del_ids) and ds.expe_id = e.id group by e.proj_id) and p.space_id = g.id and dbi.id = g.dbin_id", resultSetMapping="dataset_access_implicit")})
public class DataSetAccessPE {
    private String spaceCode;
    private String databaseInstanceUuid;
    private String databaseInstanceCode;
    public static final String DATASET_ACCESS_QUERY_NAME = "dataset_access";
    public static final String DELETED_DATASET_ACCESS_QUERY_NAME = "deleted_dataset_access";
    public static final String DATA_SET_CODES_PARAMETER_NAME = "codes";
    public static final String DELETION_IDS_PARAMETER_NAME = "del_ids";

    public static DataSetAccessPE createDataSetAccessPEForTest(String dataSetId, String dataSetCode, String groupCode, String databaseInstanceUuid, String databaseInstanceCode) {
        DataSetAccessPE newMe = new DataSetAccessPE();
        newMe.setSpaceCode(groupCode);
        newMe.setDatabaseInstanceUuid(databaseInstanceUuid);
        newMe.setDatabaseInstanceCode(databaseInstanceCode);
        return newMe;
    }

    void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    void setDatabaseInstanceUuid(String databaseInstanceUuid) {
        this.databaseInstanceUuid = databaseInstanceUuid;
    }

    void setDatabaseInstanceCode(String databaseInstanceCode) {
        this.databaseInstanceCode = databaseInstanceCode;
    }

    @Id
    public String getSpaceCode() {
        return this.spaceCode;
    }

    public String getDatabaseInstanceUuid() {
        return this.databaseInstanceUuid;
    }

    public String getDatabaseInstanceCode() {
        return this.databaseInstanceCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSetAccessPE)) {
            return false;
        }
        DataSetAccessPE that = (DataSetAccessPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getSpaceCode(), (Object)that.getSpaceCode());
        builder.append((Object)this.getDatabaseInstanceCode(), (Object)that.getDatabaseInstanceCode());
        builder.append((Object)this.getDatabaseInstanceUuid(), (Object)that.getDatabaseInstanceUuid());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getSpaceCode());
        builder.append((Object)this.getDatabaseInstanceCode());
        builder.append((Object)this.getDatabaseInstanceUuid());
        return builder.toHashCode();
    }
}

