/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.bootstrap;

import com.izforge.izpack.installer.automation.AutomatedInstaller;
import com.izforge.izpack.installer.bootstrap.InstallerGui;
import com.izforge.izpack.installer.console.ConsoleInstaller;
import com.izforge.izpack.installer.container.impl.InstallerContainer;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.StringTool;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Installer {
    public static final int INSTALLER_GUI = 0;
    public static final int INSTALLER_AUTO = 1;
    public static final int INSTALLER_CONSOLE = 2;
    public static final int CONSOLE_INSTALL = 0;
    public static final int CONSOLE_GEN_TEMPLATE = 1;
    public static final int CONSOLE_FROM_TEMPLATE = 2;
    public static final int CONSOLE_FROM_SYSTEMPROPERTIES = 3;
    public static final int CONSOLE_FROM_SYSTEMPROPERTIESMERGE = 4;
    private InstallerContainer applicationComponent;

    public static void main(String[] args) {
        try {
            Installer installer = new Installer();
            installer.start(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initContainer() throws Exception {
        this.applicationComponent = new InstallerContainer();
        this.applicationComponent.initBindings();
    }

    private void start(String[] args) {
        Debug.log(" - Logger initialized at '" + new Date(System.currentTimeMillis()) + "'.");
        Debug.log(" - commandline args: " + StringTool.stringArrayToSpaceSeparatedString(args));
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IzPack");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        try {
            Iterator<String> args_it = Arrays.asList(args).iterator();
            int type = 0;
            int consoleAction = 0;
            String path = null;
            String langcode = null;
            while (args_it.hasNext()) {
                String arg = args_it.next().trim();
                try {
                    if ("-console".equalsIgnoreCase(arg)) {
                        type = 2;
                        continue;
                    }
                    if ("-options-template".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 1;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-options".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 2;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-options-system".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 3;
                        continue;
                    }
                    if ("-options-auto".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 4;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-language".equalsIgnoreCase(arg)) {
                        langcode = args_it.next().trim();
                        continue;
                    }
                    type = 1;
                    path = arg;
                }
                catch (NoSuchElementException e) {
                    System.err.println("- ERROR -");
                    System.err.println("Option \"" + arg + "\" requires an argument!");
                    System.exit(1);
                }
            }
            this.launchInstall(type, consoleAction, path, langcode);
        }
        catch (Exception e) {
            System.err.println("- ERROR -");
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void launchInstall(int type, int consoleAction, String path, String langcode) throws Exception {
        if (type == 0 && GraphicsEnvironment.isHeadless()) {
            type = 2;
        }
        switch (type) {
            case 0: {
                InstallerGui.run();
                break;
            }
            case 1: {
                this.initContainer();
                AutomatedInstaller automatedInstaller = this.applicationComponent.getComponent(AutomatedInstaller.class);
                automatedInstaller.init(path);
                automatedInstaller.doInstall();
                break;
            }
            case 2: {
                this.initContainer();
                ConsoleInstaller consoleInstaller = this.applicationComponent.getComponent(ConsoleInstaller.class);
                consoleInstaller.setLangCode(langcode);
                consoleInstaller.run(consoleAction, path);
            }
        }
    }
}

