/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types;

import com.izforge.izpack.util.file.types.DataType;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatternSet
extends DataType
implements Cloneable {
    private Vector<NameEntry> includeList = new Vector();
    private Vector<NameEntry> excludeList = new Vector();

    public void addConfiguredPatternset(PatternSet p) {
        int n;
        int n2;
        String[] stringArray;
        String[] nestedIncludes = p.getIncludePatterns();
        String[] nestedExcludes = p.getExcludePatterns();
        if (nestedIncludes != null) {
            stringArray = nestedIncludes;
            n2 = nestedIncludes.length;
            n = 0;
            while (n < n2) {
                String nestedInclude = stringArray[n];
                this.createInclude().setName(nestedInclude);
                ++n;
            }
        }
        if (nestedExcludes != null) {
            stringArray = nestedExcludes;
            n2 = nestedExcludes.length;
            n = 0;
            while (n < n2) {
                String nestedExclude = stringArray[n];
                this.createExclude().setName(nestedExclude);
                ++n;
            }
        }
    }

    public NameEntry createInclude() {
        return this.addPatternToList(this.includeList);
    }

    public NameEntry createExclude() {
        return this.addPatternToList(this.excludeList);
    }

    public void setIncludes(String includes) {
        if (includes != null && includes.length() > 0) {
            StringTokenizer tok = new StringTokenizer(includes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createInclude().setName(tok.nextToken());
            }
        }
    }

    public void setExcludes(String excludes) {
        if (excludes != null && excludes.length() > 0) {
            StringTokenizer tok = new StringTokenizer(excludes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createExclude().setName(tok.nextToken());
            }
        }
    }

    private NameEntry addPatternToList(Vector<NameEntry> list) {
        NameEntry result = new NameEntry();
        list.addElement(result);
        return result;
    }

    public void append(PatternSet other) {
        String[] excl;
        int n;
        String[] incl = other.getIncludePatterns();
        if (incl != null) {
            String[] stringArray = incl;
            n = incl.length;
            int n2 = 0;
            while (n2 < n) {
                String anIncl = stringArray[n2];
                this.createInclude().setName(anIncl);
                ++n2;
            }
        }
        if ((excl = other.getExcludePatterns()) != null) {
            String[] stringArray = excl;
            int n3 = excl.length;
            n = 0;
            while (n < n3) {
                String anExcl = stringArray[n];
                this.createExclude().setName(anExcl);
                ++n;
            }
        }
    }

    public String[] getIncludePatterns() {
        return this.makeArray(this.includeList);
    }

    public String[] getExcludePatterns() {
        return this.makeArray(this.excludeList);
    }

    boolean hasPatterns() {
        return this.includeList.size() > 0 || this.excludeList.size() > 0;
    }

    private String[] makeArray(Vector<NameEntry> list) {
        if (list.size() == 0) {
            return null;
        }
        Vector<String> tmpNames = new Vector<String>();
        for (NameEntry ne : list) {
            String pattern = ne.getName();
            if (pattern == null || pattern.length() <= 0) continue;
            tmpNames.addElement(pattern);
        }
        Object[] result = new String[tmpNames.size()];
        tmpNames.copyInto(result);
        return result;
    }

    public String toString() {
        return "patternSet{ includes: " + this.includeList + " excludes: " + this.excludeList + " }";
    }

    public class NameEntry {
        private String name;
        private String ifCond;
        private String unlessCond;

        public void setName(String name) {
            this.name = name;
        }

        public void setIf(String cond) {
            this.ifCond = cond;
        }

        public void setUnless(String cond) {
            this.unlessCond = cond;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            if (this.name == null) {
                throw new RuntimeException("Missing attribute \"name\" for a pattern");
            }
            StringBuffer buf = new StringBuffer(this.name);
            if (this.ifCond != null || this.unlessCond != null) {
                buf.append(":");
                String connector = "";
                if (this.ifCond != null) {
                    buf.append("if->");
                    buf.append(this.ifCond);
                    connector = ";";
                }
                if (this.unlessCond != null) {
                    buf.append(connector);
                    buf.append("unless->");
                    buf.append(this.unlessCond);
                }
            }
            return buf.toString();
        }
    }
}

