/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.InitializingChecks;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.util.JsonPropertyUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonObject(value="DataSet")
public final class DataSet
implements Serializable,
IIdHolder {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String code;
    private String experimentIdentifier;
    private String sampleIdentifierOrNull;
    private String dataSetTypeCode;
    private boolean containerDataSet;
    private boolean linkDataSet;
    private boolean storageConfirmed;
    private String externalDataSetCode;
    private String externalDataSetLink;
    private ExternalDataManagementSystem externalDataManagementSystem;
    private HashMap<String, String> properties;
    private List<Metaproject> metaprojects;
    private EnumSet<Connections> retrievedConnections;
    private List<String> parentCodes = Collections.emptyList();
    private List<String> childrenCodes = Collections.emptyList();
    private List<DataSet> containedDataSets = Collections.emptyList();
    private DataSet containerOrNull;
    private EntityRegistrationDetails registrationDetails;
    private DataSetFetchOptions fetchOptions;
    private boolean isStub;

    public DataSet(DataSetInitializer initializer) {
        this.id = initializer.getId();
        InitializingChecks.checkValidString(initializer.getCode(), "Unspecified code.");
        this.code = initializer.getCode();
        this.retrievedConnections = initializer.getRetrievedConnections();
        if (initializer.isStub) {
            this.isStub = true;
        } else {
            this.experimentIdentifier = initializer.getExperimentIdentifier();
            this.sampleIdentifierOrNull = initializer.getSampleIdentifierOrNull();
            InitializingChecks.checkValidString(initializer.getDataSetTypeCode(), "Unspecified data set type code.");
            this.dataSetTypeCode = initializer.getDataSetTypeCode();
            this.properties = initializer.getProperties();
            this.metaprojects = initializer.getMetaprojects();
            this.parentCodes = initializer.getParentCodes();
            this.childrenCodes = initializer.getChildrenCodes();
            InitializingChecks.checkValidRegistrationDetails(initializer.getRegistrationDetails(), "Unspecified entity registration details.");
            this.registrationDetails = initializer.getRegistrationDetails();
            this.containerDataSet = initializer.isContainerDataSet();
            this.containerOrNull = initializer.getContainerOrNull();
            this.containedDataSets = initializer.getContainedDataSets();
            this.linkDataSet = initializer.isLinkDataSet();
            this.externalDataSetCode = initializer.getExternalDataSetCode();
            this.externalDataSetLink = initializer.getExternalDataSetLink();
            this.externalDataManagementSystem = initializer.getExternalDataManagementSystem();
            this.storageConfirmed = initializer.isStorageConfirmed();
        }
    }

    @JsonIgnore
    public Long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getExperimentIdentifier() {
        return this.experimentIdentifier;
    }

    public String getSampleIdentifierOrNull() {
        return this.sampleIdentifierOrNull;
    }

    public String getDataSetTypeCode() {
        return this.dataSetTypeCode;
    }

    @JsonIgnore
    public Date getRegistrationDate() {
        return this.getRegistrationDetails().getRegistrationDate();
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public List<Metaproject> getMetaprojects() throws IllegalArgumentException {
        if (this.metaprojects == null) {
            return new ArrayList<Metaproject>();
        }
        return Collections.unmodifiableList(this.metaprojects);
    }

    public EnumSet<Connections> getRetrievedConnections() {
        return this.retrievedConnections;
    }

    @JsonIgnore
    public List<String> getParentCodes() throws IllegalArgumentException {
        if (this.getRetrievedConnections().contains((Object)Connections.PARENTS)) {
            return Collections.unmodifiableList(this.parentCodes);
        }
        throw new IllegalArgumentException("Parent codes were not retrieved for data set " + this.getCode() + ".");
    }

    @JsonIgnore
    public List<String> getChildrenCodes() throws IllegalArgumentException {
        if (this.getRetrievedConnections().contains((Object)Connections.CHILDREN)) {
            return Collections.unmodifiableList(this.childrenCodes);
        }
        throw new IllegalArgumentException("Children codes were not retrieved for data set " + this.getCode() + ".");
    }

    public EntityRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public boolean isContainerDataSet() {
        return this.containerDataSet;
    }

    public DataSet getContainerOrNull() {
        return this.containerOrNull;
    }

    public boolean isLinkDataSet() {
        return this.linkDataSet;
    }

    public String getExternalDataSetCode() {
        return this.externalDataSetCode;
    }

    public String getExternalDataSetLink() {
        return this.externalDataSetLink;
    }

    public ExternalDataManagementSystem getExternalDataManagementSystem() {
        return this.externalDataManagementSystem;
    }

    public List<DataSet> getContainedDataSets() {
        return this.containedDataSets;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        DataSet other = (DataSet)obj;
        builder.append((Object)this.getCode(), (Object)other.getCode());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (this.isStub()) {
            builder.append((Object)"STUB");
            builder.append((Object)this.getCode());
        } else {
            builder.append((Object)this.getCode());
            builder.append((Object)this.getExperimentIdentifier());
            builder.append((Object)this.getSampleIdentifierOrNull());
            builder.append((Object)this.getDataSetTypeCode());
            TreeMap<String, String> sortedProps = new TreeMap<String, String>(this.getProperties());
            builder.append((Object)sortedProps.toString());
            if (this.retrievedConnections.contains((Object)Connections.PARENTS)) {
                builder.append(this.getParentCodes());
            }
        }
        return builder.toString();
    }

    private DataSet() {
    }

    @JsonProperty(value="id")
    private String getIdAsString() {
        return JsonPropertyUtil.toStringOrNull(this.id);
    }

    private void setIdAsString(String id) {
        this.id = JsonPropertyUtil.toLongOrNull(id);
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setExperimentIdentifier(String experimentIdentifier) {
        this.experimentIdentifier = experimentIdentifier;
    }

    private void setSampleIdentifierOrNull(String sampleIdentifierOrNull) {
        this.sampleIdentifierOrNull = sampleIdentifierOrNull;
    }

    private void setDataSetTypeCode(String dataSetTypeCode) {
        this.dataSetTypeCode = dataSetTypeCode;
    }

    private void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    @JsonProperty(value="metaprojects")
    private void setMetaprojectsJson(List<Metaproject> metaprojects) {
        this.metaprojects = metaprojects;
    }

    private void setRetrievedConnections(EnumSet<Connections> retrievedConnections) {
        this.retrievedConnections = retrievedConnections;
    }

    @JsonProperty(value="childrenCodes")
    private List<String> getChildrenCodesJson() {
        return this.retrievedConnections.contains((Object)Connections.CHILDREN) ? this.childrenCodes : null;
    }

    @JsonProperty(value="childrenCodes")
    private void setChildrenCodes(List<String> childrenCodes) {
        this.childrenCodes = childrenCodes;
    }

    @JsonProperty(value="parentCodes")
    private List<String> getParentCodesJson() {
        return this.retrievedConnections.contains((Object)Connections.PARENTS) ? this.parentCodes : null;
    }

    @JsonProperty(value="parentCodes")
    private void setParentCodes(List<String> parentCodes) {
        this.parentCodes = parentCodes;
    }

    private void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }

    private void setContainerDataSet(boolean containerDataSet) {
        this.containerDataSet = containerDataSet;
    }

    private void setContainerOrNull(DataSet containerOrNull) {
        this.containerOrNull = containerOrNull;
    }

    private void setLinkDataSet(boolean linkDataSet) {
        this.linkDataSet = linkDataSet;
    }

    private void setExternalDataSetCode(String externalDataSetCode) {
        this.externalDataSetCode = externalDataSetCode;
    }

    private void setExternalDataSetLink(String externalDataSetLink) {
        this.externalDataSetLink = externalDataSetLink;
    }

    private void setExternalDataManagementSystem(ExternalDataManagementSystem externalDataManagementSystem) {
        this.externalDataManagementSystem = externalDataManagementSystem;
    }

    private void setContainedDataSets(List<DataSet> containedDataSets) {
        this.containedDataSets = containedDataSets;
    }

    public DataSetFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(DataSetFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
        if (fetchOptions != null) {
            if (fetchOptions.isSupersetOf(new DataSetFetchOption[]{DataSetFetchOption.PARENTS, DataSetFetchOption.CHILDREN})) {
                this.setRetrievedConnections(EnumSet.of(Connections.PARENTS, Connections.CHILDREN));
            } else if (fetchOptions.isSupersetOf(new DataSetFetchOption[]{DataSetFetchOption.PARENTS})) {
                this.setRetrievedConnections(EnumSet.of(Connections.PARENTS));
            } else if (fetchOptions.isSupersetOf(new DataSetFetchOption[]{DataSetFetchOption.CHILDREN})) {
                this.setRetrievedConnections(EnumSet.of(Connections.CHILDREN));
            }
        }
    }

    public boolean isStorageConfirmed() {
        return this.storageConfirmed;
    }

    public void setStorageConfirmed(boolean storageConfirmed) {
        this.storageConfirmed = storageConfirmed;
    }

    public boolean isStub() {
        return this.isStub;
    }

    private void setStub(boolean isStub) {
        this.isStub = isStub;
    }

    @JsonObject(value="Connections")
    public static enum Connections {
        PARENTS,
        CHILDREN;

    }

    public static final class DataSetInitializer {
        private Long id;
        private String code;
        private String sampleIdentifierOrNull;
        private String experimentIdentifier;
        private String dataSetTypeCode;
        private boolean containerDataSet;
        private boolean linkDataSet;
        private String externalDataSetCode;
        private String externalDataSetLink;
        private ExternalDataManagementSystem externalDataManagementSystem;
        private EnumSet<Connections> retrievedConnections = EnumSet.noneOf(Connections.class);
        private List<String> parentCodes = Collections.emptyList();
        private List<String> childrenCodes = Collections.emptyList();
        private List<DataSet> containedDataSets = Collections.emptyList();
        private DataSet containerOrNull;
        private HashMap<String, String> properties = new HashMap();
        private List<Metaproject> metaprojects = new ArrayList<Metaproject>();
        private EntityRegistrationDetails registrationDetails;
        private boolean isStorageConfirmed = true;
        private boolean isStub;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getSampleIdentifierOrNull() {
            return this.sampleIdentifierOrNull;
        }

        public void setSampleIdentifierOrNull(String sampleIdentifierOrNull) {
            this.sampleIdentifierOrNull = sampleIdentifierOrNull;
        }

        public String getExperimentIdentifier() {
            return this.experimentIdentifier;
        }

        public void setExperimentIdentifier(String experimentIdentifier) {
            this.experimentIdentifier = experimentIdentifier;
        }

        public void setDataSetTypeCode(String dataSetTypeCode) {
            this.dataSetTypeCode = dataSetTypeCode;
        }

        public String getDataSetTypeCode() {
            return this.dataSetTypeCode;
        }

        public HashMap<String, String> getProperties() {
            return this.properties;
        }

        public void putProperty(String propCode, String value) {
            this.properties.put(propCode, value);
        }

        public List<Metaproject> getMetaprojects() {
            return this.metaprojects;
        }

        public void addMetaproject(Metaproject metaproject) {
            this.metaprojects.add(metaproject);
        }

        public void setRetrievedConnections(EnumSet<Connections> retrievedConnections) {
            this.retrievedConnections = retrievedConnections == null ? EnumSet.noneOf(Connections.class) : retrievedConnections;
        }

        public EnumSet<Connections> getRetrievedConnections() {
            return this.retrievedConnections;
        }

        public void setParentCodes(List<String> parentCodes) {
            this.parentCodes = parentCodes == null ? new ArrayList() : parentCodes;
        }

        public List<String> getParentCodes() {
            return this.parentCodes;
        }

        public List<String> getChildrenCodes() {
            return this.childrenCodes;
        }

        public void setChildrenCodes(List<String> childrenCodes) {
            this.childrenCodes = childrenCodes == null ? new ArrayList() : childrenCodes;
        }

        public void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
            this.registrationDetails = registrationDetails;
        }

        public EntityRegistrationDetails getRegistrationDetails() {
            return this.registrationDetails;
        }

        public boolean isContainerDataSet() {
            return this.containerDataSet;
        }

        public void setContainerDataSet(boolean containerDataSet) {
            this.containerDataSet = containerDataSet;
        }

        public List<DataSet> getContainedDataSets() {
            return this.containedDataSets;
        }

        public void setContainedDataSets(List<DataSet> containedDataSets) {
            this.containedDataSets = containedDataSets == null ? new ArrayList() : containedDataSets;
        }

        public DataSet getContainerOrNull() {
            return this.containerOrNull;
        }

        public void setContainerOrNull(DataSet containerOrNull) {
            this.containerOrNull = containerOrNull;
        }

        public boolean isLinkDataSet() {
            return this.linkDataSet;
        }

        public void setLinkDataSet(boolean linkDataSet) {
            this.linkDataSet = linkDataSet;
        }

        public String getExternalDataSetCode() {
            return this.externalDataSetCode;
        }

        public void setExternalDataSetCode(String externalDataSetCode) {
            this.externalDataSetCode = externalDataSetCode;
        }

        public String getExternalDataSetLink() {
            return this.externalDataSetLink;
        }

        public void setExternalDataSetLink(String externalDataSetLink) {
            this.externalDataSetLink = externalDataSetLink;
        }

        public ExternalDataManagementSystem getExternalDataManagementSystem() {
            return this.externalDataManagementSystem;
        }

        public void setExternalDataManagementSystem(ExternalDataManagementSystem externalDataManagementSystem) {
            this.externalDataManagementSystem = externalDataManagementSystem;
        }

        public boolean isStorageConfirmed() {
            return this.isStorageConfirmed;
        }

        public void setStorageConfirmed(boolean isStorageConfirmed) {
            this.isStorageConfirmed = isStorageConfirmed;
        }

        public void setStub(boolean isStub) {
            this.isStub = isStub;
        }
    }
}

