/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class DatabaseModificationKind
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DatabaseModificationKind[] EMPTY_ARRAY = new DatabaseModificationKind[0];
    private ObjectKind objectType;
    private OperationKind operationKind;

    private DatabaseModificationKind() {
    }

    public static final void addAny(Collection<DatabaseModificationKind> result, ObjectKind objectType) {
        result.add(DatabaseModificationKind.createOrDelete(objectType));
        result.add(DatabaseModificationKind.edit(objectType));
    }

    public static final DatabaseModificationKind[] any(ObjectKind objectType) {
        ArrayList<DatabaseModificationKind> result = new ArrayList<DatabaseModificationKind>();
        result.add(DatabaseModificationKind.createOrDelete(objectType));
        result.add(DatabaseModificationKind.edit(objectType));
        return result.toArray(EMPTY_ARRAY);
    }

    public static final DatabaseModificationKind createOrDelete(ObjectKind objectType) {
        return new DatabaseModificationKind(objectType, OperationKind.CREATE_OR_DELETE);
    }

    public static final DatabaseModificationKind edit(ObjectKind objectType) {
        return new DatabaseModificationKind(objectType, OperationKind.UPDATE);
    }

    public DatabaseModificationKind(ObjectKind objectType, OperationKind operationKind) {
        this.objectType = objectType;
        this.operationKind = operationKind;
    }

    public ObjectKind getObjectType() {
        return this.objectType;
    }

    public OperationKind getOperationKind() {
        return this.operationKind;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DatabaseModificationKind)) {
            return false;
        }
        DatabaseModificationKind that = (DatabaseModificationKind)obj;
        return this.objectType == that.objectType && this.operationKind == that.operationKind;
    }

    public int hashCode() {
        return 17 * this.objectType.hashCode() + this.operationKind.hashCode();
    }

    public String toString() {
        return "modification(object type: " + (Object)((Object)this.objectType) + ", kind: " + (Object)((Object)this.operationKind) + ")";
    }

    public static enum ObjectKind implements IsSerializable
    {
        AUTHORIZATION_GROUP,
        SAMPLE,
        EXPERIMENT,
        MATERIAL,
        DATA_SET,
        SAMPLE_TYPE,
        EXPERIMENT_TYPE,
        MATERIAL_TYPE,
        DATASET_TYPE,
        FILE_FORMAT_TYPE,
        PROJECT,
        SPACE,
        PROPERTY_TYPE,
        PROPERTY_TYPE_ASSIGNMENT,
        VOCABULARY,
        VOCABULARY_TERM,
        ROLE_ASSIGNMENT,
        PERSON,
        GRID_CUSTOM_FILTER,
        GRID_CUSTOM_COLUMN,
        SCRIPT,
        DELETION,
        POSTREGISTRATION_QUEUE,
        QUERY,
        METAPROJECT;

    }

    public static enum OperationKind implements IsSerializable
    {
        CREATE_OR_DELETE,
        UPDATE;

    }
}

