/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.CopyModeExisting;
import ch.systemsx.cisd.common.filesystem.FastHardLinkMaker;
import ch.systemsx.cisd.common.filesystem.HardLinkMaker;
import ch.systemsx.cisd.common.filesystem.IDirectoryImmutableCopier;
import ch.systemsx.cisd.common.filesystem.IFileImmutableCopier;
import ch.systemsx.cisd.common.filesystem.IImmutableCopier;
import ch.systemsx.cisd.common.filesystem.RecursiveHardLinkMaker;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncBasedRecursiveHardLinkMaker;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.time.TimingParameters;
import java.io.File;
import org.apache.log4j.Logger;

public class FastRecursiveHardLinkMaker
implements IImmutableCopier {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FastRecursiveHardLinkMaker.class);
    private static final String RSYNC_EXEC = "rsync";
    private static final String LN_EXEC = "ln";
    private static final int DEFAULT_MAX_ERRORS_TO_IGNORE = 3;
    private final IImmutableCopier fallbackCopierOrNull;
    private final IFileImmutableCopier internFileCopierOrNull;
    private final IDirectoryImmutableCopier rsyncBasedDirectoryCopierOrNull;

    public static final IImmutableCopier tryCreate() {
        return FastRecursiveHardLinkMaker.tryCreate(TimingParameters.getDefaultParameters());
    }

    public static final IImmutableCopier tryCreate(TimingParameters timingParameters) {
        File rsyncExecOrNull = OSUtilities.findExecutable(RSYNC_EXEC);
        File lnExecOrNull = OSUtilities.findExecutable(LN_EXEC);
        try {
            return FastRecursiveHardLinkMaker.create(rsyncExecOrNull, lnExecOrNull, timingParameters, false);
        }
        catch (ConfigurationFailureException configurationFailureException) {
            return null;
        }
    }

    public static final IImmutableCopier create(File rsyncExecutable, File lnExecutable) {
        return FastRecursiveHardLinkMaker.create(rsyncExecutable, lnExecutable, TimingParameters.getDefaultParameters(), false);
    }

    public static final IImmutableCopier create(File rsyncExecutable, File lnExecutable, TimingParameters parameters) {
        return new FastRecursiveHardLinkMaker(rsyncExecutable, lnExecutable, parameters, false);
    }

    public static final IImmutableCopier create(File rsyncExecutable, File lnExecutable, TimingParameters parameters, boolean neverUseNative) {
        return new FastRecursiveHardLinkMaker(rsyncExecutable, lnExecutable, parameters, neverUseNative);
    }

    private FastRecursiveHardLinkMaker(File rsyncExcutable, File lnExecutable, TimingParameters timingParameters, boolean neverUseNative) throws ConfigurationFailureException {
        this.internFileCopierOrNull = neverUseNative ? null : FastHardLinkMaker.tryCreate(timingParameters);
        this.rsyncBasedDirectoryCopierOrNull = rsyncExcutable == null ? null : new RsyncBasedRecursiveHardLinkMaker(rsyncExcutable, timingParameters, 3);
        this.fallbackCopierOrNull = this.internFileCopierOrNull == null ? RecursiveHardLinkMaker.tryCreate(HardLinkMaker.create(lnExecutable, timingParameters)) : RecursiveHardLinkMaker.tryCreate(this.internFileCopierOrNull);
        if (this.internFileCopierOrNull == null && this.fallbackCopierOrNull == null || this.rsyncBasedDirectoryCopierOrNull == null && this.fallbackCopierOrNull == null) {
            throw new ConfigurationFailureException("FastRecursiveHardLinkMaker not operational");
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info(timingParameters.toString());
            if (this.internFileCopierOrNull != null) {
                operationLog.info("Using native library to create hard link copies of files.");
            } else {
                operationLog.info("Using 'ln' to create hard link copies of files.");
            }
            if (this.rsyncBasedDirectoryCopierOrNull != null) {
                operationLog.info("Using 'rsync' to traverse directories when making recursive hard link copies.");
            } else {
                operationLog.info("Using Java to traverse directories when making recursive hard link copies");
            }
        }
    }

    @Override
    public Status copyImmutably(File source, File destinationDirectory, String nameOrNull) {
        return this.copyImmutably(source, destinationDirectory, nameOrNull, CopyModeExisting.ERROR);
    }

    @Override
    public Status copyImmutably(File source, File destinationDirectory, String nameOrNull, CopyModeExisting mode) {
        if (source.isDirectory()) {
            File target = FastRecursiveHardLinkMaker.getTarget(source, destinationDirectory, nameOrNull, mode);
            if (!(this.rsyncBasedDirectoryCopierOrNull == null || mode == CopyModeExisting.OVERWRITE && target.exists())) {
                return this.rsyncBasedDirectoryCopierOrNull.copyDirectoryImmutably(source, destinationDirectory, nameOrNull, mode);
            }
            return this.fallbackCopierOrNull.copyImmutably(source, destinationDirectory, nameOrNull, mode);
        }
        if (this.internFileCopierOrNull != null) {
            return this.internFileCopierOrNull.copyFileImmutably(source, destinationDirectory, nameOrNull, mode);
        }
        return this.fallbackCopierOrNull.copyImmutably(source, destinationDirectory, nameOrNull, mode);
    }

    private static final File getTarget(File srcDir, File destDir, String nameOrNull, CopyModeExisting mode) throws IOExceptionUnchecked {
        String name = nameOrNull == null ? srcDir.getName() : nameOrNull;
        return new File(destDir, name);
    }
}

