/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.base.image.IImageTransformer;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import java.awt.image.BufferedImage;

@JsonObject(value="ExampleImageTransformerFactory")
public class ExampleImageTransformerFactory
implements IImageTransformerFactory {
    private static final long serialVersionUID = 1L;
    private final String colorPattern;
    private final int brightnessDelta;

    public ExampleImageTransformerFactory(String colorPattern) {
        this(colorPattern, 0);
    }

    public ExampleImageTransformerFactory(int brightnessDelta) {
        this("rgb", brightnessDelta);
    }

    public ExampleImageTransformerFactory(String colorPattern, int brightnessDelta) {
        this.colorPattern = colorPattern;
        this.brightnessDelta = brightnessDelta;
    }

    @Override
    public IImageTransformer createTransformer() {
        return new IImageTransformer(){

            @Override
            public BufferedImage transform(BufferedImage input) {
                int width = input.getWidth();
                int height = input.getHeight();
                BufferedImage output = new BufferedImage(width, height, 1);
                int x = 0;
                while (x < width) {
                    int y = 0;
                    while (y < height) {
                        int rgb = input.getRGB(x, y);
                        Color color = new Color(rgb);
                        output.setRGB(x, y, (this.calcNewColor(color, 0) << 16) + (this.calcNewColor(color, 1) << 8) + this.calcNewColor(color, 2));
                        ++y;
                    }
                    ++x;
                }
                return output;
            }

            private int calcNewColor(Color color, int colorIndex) {
                return color.getColor(ExampleImageTransformerFactory.this.colorPattern.charAt(colorIndex)) + ExampleImageTransformerFactory.this.brightnessDelta;
            }
        };
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.colorPattern + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.brightnessDelta;
        result = 31 * result + (this.colorPattern == null ? 0 : this.colorPattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExampleImageTransformerFactory other = (ExampleImageTransformerFactory)obj;
        if (this.brightnessDelta != other.brightnessDelta) {
            return false;
        }
        return !(this.colorPattern == null ? other.colorPattern != null : !this.colorPattern.equals(other.colorPattern));
    }

    private static final class Color {
        private int red;
        private int green;
        private int blue;

        Color(int rgb) {
            this.red = rgb >> 16 & 0xFF;
            this.green = rgb >> 8 & 0xFF;
            this.blue = rgb & 0xFF;
        }

        int getColor(char colorSymbol) {
            switch (colorSymbol) {
                case 'r': {
                    return this.red;
                }
                case 'g': {
                    return this.green;
                }
                case 'b': {
                    return this.blue;
                }
            }
            return 0;
        }
    }
}

