/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.exceptions;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.MasqueradingException;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ExceptionUtils {
    private static final String[] ACCEPTED_PACKAGE_NAME_DEPENDENCIES = new String[]{"java.lang", "ch.systemsx.cisd.base", "ch.systemsx.cisd.common.exceptions"};

    ExceptionUtils() {
    }

    private static final Exception createMasqueradingException(Exception exception, Collection<String> acceptedPackages) {
        Exception rootException = CheckedExceptionTunnel.unwrapIfNecessary(exception);
        if (ExceptionUtils.isCandidateForMasquerading(rootException, acceptedPackages)) {
            return new MasqueradingException(rootException);
        }
        return rootException;
    }

    private static final void copyCauseException(Exception fromException, Exception toException, Collection<String> acceptedPackages) {
        assert (fromException != null) : "Unspecified 'from' Exception.";
        assert (toException != null) : "Unspecified 'to' Exception.";
        Exception fromCauseException = (Exception)org.apache.commons.lang.exception.ExceptionUtils.getCause(fromException);
        if (fromCauseException != null && fromCauseException != fromException) {
            Exception toCauseException = ExceptionUtils.createMasqueradingException(fromCauseException, acceptedPackages);
            if (toException.getCause() != toCauseException && !ClassUtils.setFieldValue(toException, "cause", toCauseException)) {
                org.apache.commons.lang.exception.ExceptionUtils.setCause(toException, toCauseException);
            }
            ExceptionUtils.copyCauseException(fromCauseException, toCauseException, acceptedPackages);
        }
    }

    static final boolean isCandidateForMasquerading(Exception exception, Collection<String> acceptedPackages) {
        assert (exception != null) : "Unspecified exception.";
        String className = exception.getClass().getName();
        for (String packageName : ExceptionUtils.createSetOfAcceptedPackages(acceptedPackages)) {
            if (!className.startsWith(packageName)) continue;
            return false;
        }
        return true;
    }

    private static Set<String> createSetOfAcceptedPackages(Collection<String> acceptedPackages) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(Arrays.asList(ACCEPTED_PACKAGE_NAME_DEPENDENCIES));
        set.addAll(acceptedPackages);
        return set;
    }

    public static final Exception createMasqueradingExceptionIfNeeded(Exception exception, Collection<String> acceptedPackages) {
        assert (exception != null) : "Unspecified SQL Exception.";
        Exception clientSafeException = ExceptionUtils.createMasqueradingException(exception, acceptedPackages);
        ExceptionUtils.copyCauseException(exception, clientSafeException, acceptedPackages);
        return clientSafeException;
    }

    public static final <T extends Throwable> T tryGetThrowableOfClass(Throwable throwable, Class<T> clazz) {
        assert (throwable != null) : "Unspecified throwable";
        assert (clazz != null) : "Unspecified class";
        if (clazz.isAssignableFrom(throwable.getClass())) {
            return (T)((Throwable)clazz.cast(throwable));
        }
        Throwable cause = org.apache.commons.lang.exception.ExceptionUtils.getCause(throwable);
        if (cause != null) {
            return ExceptionUtils.tryGetThrowableOfClass(cause, clazz);
        }
        return null;
    }

    public static Throwable getEndOfChain(Throwable throwable) {
        Throwable cause = throwable.getCause();
        return cause == null ? throwable : ExceptionUtils.getEndOfChain(cause);
    }
}

