/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.servlet;

import ch.systemsx.cisd.base.utilities.AbstractBuildAndEnvironmentInfo;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import java.lang.reflect.Field;
import java.util.List;
import javax.servlet.ServletContextEvent;
import org.apache.log4j.Logger;
import org.springframework.web.context.ContextLoaderListener;

public final class CISDContextLoaderListener
extends ContextLoaderListener {
    private static final Logger statusLog = LogFactory.getLogger(LogCategory.STATUS, CISDContextLoaderListener.class);

    @Override
    public final void contextInitialized(ServletContextEvent event) {
        this.registerDefaultUncaughtExceptionHandler();
        LogInitializer.init();
        this.printBuildAndEnvironmentInfo(event);
        try {
            super.contextInitialized(event);
        }
        catch (Exception ex) {
            statusLog.error("Couldn't create application context.", ex);
        }
    }

    private void printBuildAndEnvironmentInfo(ServletContextEvent event) {
        String nameOfBuildInfoAndEnvironmentClass = event.getServletContext().getInitParameter("infoClass");
        try {
            Class<?> clazz = Class.forName(nameOfBuildInfoAndEnvironmentClass);
            Field field = clazz.getField("INSTANCE");
            AbstractBuildAndEnvironmentInfo info = (AbstractBuildAndEnvironmentInfo)field.get(null);
            List<String> environmentInfo = info.getEnvironmentInfo();
            for (String line : environmentInfo) {
                statusLog.info(line);
            }
        }
        catch (Exception ex) {
            statusLog.warn("Couldn't get build and environment info: " + ex);
        }
    }

    private void registerDefaultUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread2, Throwable th) {
                statusLog.error(String.format("An unexpected error occured in thread [%s].", thread2.getName()), th);
            }
        });
    }
}

