/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.test;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class SerializabilityTest {
    private Serializable obj;

    protected abstract Serializable createInstance() throws Exception;

    @BeforeClass
    public final void setUp() throws Exception {
        this.obj = this.createInstance();
        assert (this.obj != null) : "createInstance() returned null";
    }

    @Test
    public final void testSerializability() throws Exception {
        byte[] serial = SerializationUtils.serialize(this.obj);
        Serializable deserial = (Serializable)SerializationUtils.deserialize(serial);
        this.checkThawedObject(this.obj, deserial);
    }

    public void checkThawedObject(Serializable expected, Serializable actual) throws Exception {
        assert (expected.equals(actual)) : "thawed object comparison";
    }
}

