/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation;

import ch.systemsx.cisd.common.jython.JythonUtils;
import ch.systemsx.cisd.common.jython.PythonInterpreter;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationScriptReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyFunction;
import org.python.core.PyObject;

public class ValidationScriptRunner {
    private static final String FILE_VALIDATION_FUNCTION_NAME = "validate_data_set_file";
    private static final String EXTRACT_METADATA_FUNCTION_NAME = "extract_metadata";
    private final PythonInterpreter interpreter;
    private final String scriptString;

    public static ValidationScriptRunner createValidatorFromScriptPaths(String[] scriptPaths) {
        return ValidationScriptRunner.createValidatorFromScriptPaths(scriptPaths, true);
    }

    public static ValidationScriptRunner createValidatorFromScriptPaths(String[] scriptPaths, boolean isolateJythonSystemState) {
        String scriptStringOrNull = ValidationScriptReader.tryReadValidationScript(scriptPaths);
        if (StringUtils.isBlank(scriptStringOrNull)) {
            return new NullValidationScriptRunner();
        }
        return new ValidationScriptRunner(scriptStringOrNull, isolateJythonSystemState);
    }

    public static ValidationScriptRunner createValidatorFromScriptString(String scriptString) {
        return ValidationScriptRunner.createValidatorFromScriptString(scriptString, true);
    }

    public static ValidationScriptRunner createValidatorFromScriptString(String scriptString, boolean isolateJythonSystemState) {
        if (scriptString == null) {
            return new NullValidationScriptRunner();
        }
        return new ValidationScriptRunner(scriptString, isolateJythonSystemState);
    }

    private ValidationScriptRunner(String scriptString, boolean isolateJythonSystemState) {
        this.interpreter = isolateJythonSystemState ? PythonInterpreter.createIsolatedPythonInterpreter() : PythonInterpreter.createNonIsolatedPythonInterpreter();
        this.scriptString = scriptString;
        this.interpreter.exec(this.scriptString);
    }

    protected ValidationScriptRunner(boolean scriptIsNull) {
        this.interpreter = null;
        this.scriptString = null;
    }

    public List<ValidationError> validate(File dataSetFile) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        PyFunction function = this.tryJythonFunction(FILE_VALIDATION_FUNCTION_NAME);
        PyObject result = function.__call__(Py.java2py(dataSetFile));
        if (result != null) {
            errors.addAll((Collection)((Object)result));
        }
        return errors;
    }

    public Map<String, String> extractMetadata(File dataSetFile) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        PyFunction function = this.tryJythonFunction(EXTRACT_METADATA_FUNCTION_NAME);
        if (function == null) {
            return Collections.emptyMap();
        }
        PyObject result = function.__call__(Py.java2py(dataSetFile));
        if (result != null) {
            Map<String, String> javaResult = null;
            javaResult = result instanceof PyDictionary ? JythonUtils.convertPyDictToMap((PyDictionary)result) : (Map<String, String>)((Object)result);
            metadata.putAll(javaResult);
        }
        return metadata;
    }

    public String getScriptString() {
        return this.scriptString;
    }

    private PyFunction tryJythonFunction(String functionName) {
        try {
            PyFunction function = this.interpreter.get(functionName, PyFunction.class);
            return function;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class NullValidationScriptRunner
    extends ValidationScriptRunner {
        public NullValidationScriptRunner() {
            super(true);
        }

        @Override
        public List<ValidationError> validate(File dataSetFile) {
            return Collections.emptyList();
        }

        @Override
        public Map<String, String> extractMetadata(File dataSetFile) {
            return Collections.emptyMap();
        }
    }
}

