/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.mail;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.From;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class MailClient
extends Authenticator
implements IMailClient {
    private static final String FILE_PREFIX = "file://";
    public static final String MAIL_SMTP_PASSWORD = "mail.smtp.password";
    public static final String MAIL_TEST_ADDRESS = "mail.test.address";
    private static final String UNICODE_CHARSET = "utf-8";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MailClient.class);
    private final String smtpUsername;
    private final String smtpPassword;
    private final String smtpHost;
    private final String from;
    private final String testAddress;

    public MailClient(String from, String smtpHost) {
        this(from, smtpHost, null, null, null);
    }

    public MailClient(MailClientParameters parameters) {
        this(parameters.getFrom(), parameters.getSmtpHost(), parameters.getSmtpUser(), parameters.getSmtpPassword(), null);
    }

    public MailClient(Properties properties) {
        this(properties.getProperty("mail.from"), properties.getProperty("mail.smtp.host"), properties.getProperty("mail.smtp.user"), properties.getProperty(MAIL_SMTP_PASSWORD), properties.getProperty(MAIL_TEST_ADDRESS));
    }

    public MailClient(String from, String smtpHost, String smtpUsername, String smtpPassword, String testAddress) {
        assert (from != null);
        assert (smtpHost != null);
        this.from = from;
        this.smtpHost = smtpHost;
        this.smtpUsername = smtpUsername;
        this.smtpPassword = smtpPassword;
        this.testAddress = testAddress;
    }

    private final Properties createProperties() {
        Properties properties = null;
        try {
            properties = new Properties(System.getProperties());
        }
        catch (SecurityException securityException) {
            properties = new Properties();
        }
        if (this.smtpUsername != null) {
            properties.put("mail.smtp.user", this.smtpUsername);
        }
        if (this.smtpHost != null) {
            properties.put("mail.smtp.host", this.smtpHost);
        }
        if (StringUtils.isNotBlank((String)this.smtpPassword) && StringUtils.isNotBlank((String)this.smtpUsername)) {
            properties.put("mail.smtp.auth", Boolean.TRUE.toString());
        }
        properties.put("mail.debug", operationLog.isDebugEnabled() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        properties.put("mail.transport.protocol", "smtp");
        return properties;
    }

    @Override
    public void sendTestEmail() {
        if (this.testAddress != null) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)"Sending test email.");
            }
            this.sendEmailMessage("test", "", null, null, new EMailAddress(this.testAddress));
        } else if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)"Test address was not provided.");
        }
    }

    private final Session createSession() {
        boolean mailSmtpAuth;
        Properties properties = this.createProperties();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Creating mail session with following properties '" + properties + "'."));
        }
        Session session = Session.getInstance((Properties)properties, (Authenticator)((mailSmtpAuth = Boolean.parseBoolean(properties.getProperty("mail.smtp.auth"))) ? this : null));
        session.setDebug(operationLog.isDebugEnabled());
        return session;
    }

    private static final InternetAddress createInternetAddress(From internetAddressOrNull) {
        if (internetAddressOrNull == null) {
            return null;
        }
        return MailClient.createInternetAddress(internetAddressOrNull.getValue());
    }

    private static final InternetAddress createInternetAddress(String internetAddressOrNull) {
        if (internetAddressOrNull == null) {
            return null;
        }
        try {
            return new InternetAddress(internetAddressOrNull);
        }
        catch (AddressException e) {
            operationLog.error((Object)("Could not parse address [" + internetAddressOrNull + "]."), (Throwable)e);
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)e));
        }
    }

    private static final InternetAddress[] createInternetAddresses(EMailAddress[] addressesOrNull) {
        if (addressesOrNull == null) {
            return null;
        }
        InternetAddress[] addresses = new InternetAddress[addressesOrNull.length];
        int i = 0;
        while (i < addresses.length) {
            addresses[i] = MailClient.createInternetAddress(addressesOrNull[i]);
            ++i;
        }
        return addresses;
    }

    private static final InternetAddress[] createInternetAddresses(String[] addressesOrNull) {
        if (addressesOrNull == null) {
            return null;
        }
        InternetAddress[] addresses = new InternetAddress[addressesOrNull.length];
        int i = 0;
        while (i < addresses.length) {
            addresses[i] = MailClient.createInternetAddress(addressesOrNull[i]);
            ++i;
        }
        return addresses;
    }

    private static final InternetAddress createInternetAddress(EMailAddress addressOrNull) {
        if (addressOrNull == null || addressOrNull.tryGetEmailAddress() == null) {
            return null;
        }
        try {
            return new InternetAddress(addressOrNull.tryGetEmailAddress(), addressOrNull.tryGetPersonalName());
        }
        catch (Exception e) {
            operationLog.error((Object)("Could not parse address [" + addressOrNull + "]."), (Throwable)e);
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    @Override
    public final void sendMessage(String subject, final String content, String replyToOrNull, From fromOrNull, String ... recipients) throws EnvironmentFailureException {
        IMessagePreparer messagePreparer = new IMessagePreparer(){

            @Override
            public void prepareMessage(MimeMessage msg) throws MessagingException {
                msg.setText(content);
            }
        };
        this.privateSendMessage(messagePreparer, subject, MailClient.createInternetAddress(replyToOrNull), MailClient.createInternetAddress(fromOrNull), MailClient.createInternetAddresses(recipients));
    }

    @Override
    public void sendEmailMessage(String subject, final String content, EMailAddress replyToOrNull, EMailAddress fromOrNull, EMailAddress ... recipients) throws EnvironmentFailureException {
        IMessagePreparer messagePreparer = new IMessagePreparer(){

            @Override
            public void prepareMessage(MimeMessage msg) throws MessagingException {
                msg.setText(content);
            }
        };
        this.privateSendMessage(messagePreparer, subject, MailClient.createInternetAddress(replyToOrNull), MailClient.createInternetAddress(fromOrNull), MailClient.createInternetAddresses(recipients));
    }

    @Override
    public final void sendMessageWithAttachment(String subject, final String content, final String filename, final DataHandler attachmentContent, String replyTo, From fromOrNull, String ... recipients) throws EnvironmentFailureException {
        IMessagePreparer messagePreparer = new IMessagePreparer(){

            @Override
            public void prepareMessage(MimeMessage msg) throws MessagingException {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart messageText = new MimeBodyPart();
                messageText.setText(content);
                multipart.addBodyPart((BodyPart)messageText);
                MimeBodyPart messageAttachment = new MimeBodyPart();
                messageAttachment.setDataHandler(attachmentContent);
                messageAttachment.setFileName(filename);
                multipart.addBodyPart((BodyPart)messageAttachment);
                msg.setContent((Multipart)multipart);
            }
        };
        this.privateSendMessage(messagePreparer, subject, MailClient.createInternetAddress(replyTo), MailClient.createInternetAddress(fromOrNull), MailClient.createInternetAddresses(recipients));
    }

    @Override
    public void sendEmailMessageWithAttachment(String subject, final String content, final String filename, final DataHandler attachmentContent, EMailAddress replyToOrNull, EMailAddress fromOrNull, EMailAddress ... recipients) throws EnvironmentFailureException {
        IMessagePreparer messagePreparer = new IMessagePreparer(){

            @Override
            public void prepareMessage(MimeMessage msg) throws MessagingException {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart messageText = new MimeBodyPart();
                messageText.setText(content);
                multipart.addBodyPart((BodyPart)messageText);
                MimeBodyPart messageAttachment = new MimeBodyPart();
                messageAttachment.setDataHandler(attachmentContent);
                messageAttachment.setFileName(filename);
                multipart.addBodyPart((BodyPart)messageAttachment);
                msg.setContent((Multipart)multipart);
            }
        };
        this.privateSendMessage(messagePreparer, subject, MailClient.createInternetAddress(replyToOrNull), MailClient.createInternetAddress(fromOrNull), MailClient.createInternetAddresses(recipients));
    }

    /*
     * Unable to fully structure code
     */
    private final void privateSendMessage(IMessagePreparer messagePreparerOrNull, String subject, InternetAddress replyTo, InternetAddress fromOrNull, InternetAddress[] recipients) throws EnvironmentFailureException {
        block6: {
            block7: {
                v0 = fromPerMail = fromOrNull != null ? fromOrNull : MailClient.createInternetAddress(this.from);
                if (MailClient.operationLog.isInfoEnabled()) {
                    MailClient.operationLog.info((Object)("Sending message from '" + fromPerMail + "' to recipients '" + Arrays.asList(recipients) + "'"));
                }
                msg = new MimeMessage(this.createSession());
                try {
                    msg.setFrom((Address)fromPerMail);
                    if (replyTo != null) {
                        replyToAddress = new InternetAddress[]{replyTo};
                        msg.setReplyTo((Address[])replyToAddress);
                    }
                    msg.addRecipients(Message.RecipientType.TO, (Address[])recipients);
                    msg.setSubject(subject, "utf-8");
                    if (messagePreparerOrNull != null) {
                        messagePreparerOrNull.prepareMessage(msg);
                    }
                    msg.setSentDate(new Date());
                    this.send(msg);
                    break block6;
                }
                catch (MessagingException ex) {
                    b = new StringBuilder();
                    b.append("Sending e-mail with subject '");
                    b.append(subject);
                    b.append("' to recipients ");
                    b.append(Arrays.asList(recipients));
                    b.append(" failed.");
                    if (!(ex instanceof SendFailedException) || (invalidAddressesOrNull = ((SendFailedException)ex).getInvalidAddresses()) == null || invalidAddressesOrNull.length <= 0) break block7;
                    b.append(" These email addresses are invalid:\n");
                    var14_12 = invalidAddressesOrNull;
                    var13_13 = invalidAddressesOrNull.length;
                    var12_14 = 0;
                    ** while (var12_14 < var13_13)
                }
lbl-1000:
                // 1 sources

                {
                    address = var14_12[var12_14];
                    b.append(address.toString());
                    b.append('\n');
                    ++var12_14;
                    continue;
                }
            }
            b.append("\nDetailed failure description:\n");
            b.append(ex.toString());
            throw new EnvironmentFailureException(b.toString(), ex);
        }
    }

    private void send(MimeMessage msg) throws MessagingException {
        if (this.smtpHost.startsWith(FILE_PREFIX)) {
            this.writeMessageToFile(msg);
        } else {
            Transport.send((Message)msg);
        }
    }

    private void writeMessageToFile(MimeMessage msg) throws MessagingException {
        File emailFolder = new File(this.smtpHost.substring(FILE_PREFIX.length()));
        if (emailFolder.exists()) {
            if (!emailFolder.isDirectory()) {
                throw new EnvironmentFailureException("There exists already a file but not a folder with path '" + emailFolder.getAbsolutePath() + "'.");
            }
        } else if (!emailFolder.mkdirs()) {
            throw new EnvironmentFailureException("Couldn't create email folder '" + emailFolder.getAbsolutePath() + "'.");
        }
        File file = FileUtilities.createNextNumberedFile(new File(emailFolder, "email"), null);
        StringBuilder builder = new StringBuilder();
        Enumeration headers = msg.getAllHeaderLines();
        while (headers.hasMoreElements()) {
            builder.append((String)headers.nextElement()).append('\n');
        }
        builder.append("Content:\n");
        try {
            Object content = msg.getContent();
            if (content instanceof Multipart) {
                Multipart multipart = (Multipart)content;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                multipart.writeTo((OutputStream)os);
                builder.append(os.toString());
            } else {
                builder.append(content);
            }
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        FileUtilities.writeToFile(file, builder.toString());
    }

    protected final PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.smtpUsername, this.smtpPassword);
    }

    private static interface IMessagePreparer {
        public void prepareMessage(MimeMessage var1) throws MessagingException;
    }
}

