/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.email;

import ch.ethz.bsse.cisd.dsu.tracking.dto.TrackedEntities;
import ch.ethz.bsse.cisd.dsu.tracking.email.Email;
import ch.ethz.bsse.cisd.dsu.tracking.email.EmailWithSummary;
import ch.ethz.bsse.cisd.dsu.tracking.email.EntityTrackingEmailData;
import ch.ethz.bsse.cisd.dsu.tracking.email.EntityTrackingEmailDataManager;
import ch.ethz.bsse.cisd.dsu.tracking.email.IEntityTrackingEmailGenerator;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class EntityTrackingEmailGenerator
implements IEntityTrackingEmailGenerator {
    private static final String NOTIFICATION_EMAIL_FROM = "mail.from";
    private static final String NOTIFICATION_EMAIL_REPLY_TO = "notification-email-reply-to";
    private static final String NOTIFICATION_EMAIL_SUBJECT = "notification-email-subject";
    private static final String AFFILIATION_NOTIFICATION_EMAIL_CONTACT_SUFFIX = "-affiliation-notification-email-contact";
    private final String from;
    private final String replyTo;
    private final String subject;
    private final String template;

    public EntityTrackingEmailGenerator(Properties properties, String template) {
        this.from = PropertyUtils.getMandatoryProperty(properties, NOTIFICATION_EMAIL_FROM);
        this.replyTo = PropertyUtils.getMandatoryProperty(properties, NOTIFICATION_EMAIL_REPLY_TO);
        this.subject = PropertyUtils.getMandatoryProperty(properties, NOTIFICATION_EMAIL_SUBJECT);
        this.template = template;
        Map<String, String> recipientsByAffiliation = this.retrieveRecipientsByAffiliation(properties);
        EntityTrackingEmailDataManager.initialize(recipientsByAffiliation);
    }

    private Map<String, String> retrieveRecipientsByAffiliation(Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            String propertyKey = (String)key;
            if (!propertyKey.endsWith(AFFILIATION_NOTIFICATION_EMAIL_CONTACT_SUFFIX)) continue;
            String affiliation = propertyKey.substring(0, propertyKey.length() - AFFILIATION_NOTIFICATION_EMAIL_CONTACT_SUFFIX.length());
            String affiliationRecipient = PropertyUtils.getMandatoryProperty(properties, propertyKey);
            result.put(affiliation, affiliationRecipient);
        }
        return result;
    }

    @Override
    public List<EmailWithSummary> generateEmails(TrackedEntities trackedEntities) {
        Collection<EntityTrackingEmailData> emailDataGroupedByRecipient = EntityTrackingEmailDataManager.groupByRecipient(trackedEntities);
        ArrayList<EmailWithSummary> results = new ArrayList<EmailWithSummary>();
        for (EntityTrackingEmailData emailData : emailDataGroupedByRecipient) {
            results.add(this.createEmailWithSummary(emailData));
        }
        return results;
    }

    private EmailWithSummary createEmailWithSummary(EntityTrackingEmailData emailData) {
        return new EmailWithSummary(this.createEmail(emailData), emailData.getDescription());
    }

    private Email createEmail(EntityTrackingEmailData emailData) {
        String content = EmailContentGenerator.fillTemplateWithData(this.template, emailData);
        String recipient = emailData.getRecipient();
        return new Email(this.subject, content, this.replyTo, this.from, EntityTrackingEmailGenerator.filterBlanks(recipient.split(",|;| ")));
    }

    private static String[] filterBlanks(String[] arr) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!StringUtils.isBlank(s)) {
                result.add(s.trim());
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    private static final class EmailContentGenerator {
        private static final char NEW_LINE = '\n';
        private static final int SEPARATOR_LINE_WIDTH = 100;
        private static final char SECTION_SEPARATOR_CHAR = '#';
        private static final char SUBSECTION_SEPARATOR_CHAR = '-';
        private static final String SECTION_SEPARATOR_LINE = EmailContentGenerator.createSeparatorLine('#');
        private static final String SUBSECTION_SEPARATOR_LINE = EmailContentGenerator.createSeparatorLine('-');
        private static final String EXTERNAL_SAMPLE_NAME_PROPERTY_CODE = "EXTERNAL_SAMPLE_NAME";
        private static final String INDEX1_PROPERTY_CODE = "BARCODE";
        private static final String INDEX2_PROPERTY_CODE = "INDEX2";
        private static final String PERMLINK_LABEL = "See details in openBIS";
        private static final String GENARATED_CONTENT_TARGET = "{generated-content}";

        private EmailContentGenerator() {
        }

        public static String fillTemplateWithData(String template, EntityTrackingEmailData emailData) {
            return template.replace(GENARATED_CONTENT_TARGET, EmailContentGenerator.generateContent(emailData));
        }

        private static String generateContent(EntityTrackingEmailData emailData) {
            StringBuilder sb = new StringBuilder();
            EmailContentGenerator.appendDataSetsData(sb, emailData.getDataSets());
            EmailContentGenerator.appendSequencingSamplesData(sb, emailData.getSequencingSamplesToBeProcessed(), false);
            EmailContentGenerator.appendSequencingSamplesData(sb, emailData.getSequencingSamplesProcessed(), true);
            return sb.toString();
        }

        private static void appendSequencingSamplesData(StringBuilder sb, Collection<Sample> sequencingSamples, boolean processed) {
            for (Sample sequencingSample : sequencingSamples) {
                String externalSampleName = EmailContentGenerator.getExternalSampleName(sequencingSample);
                EmailContentGenerator.appendln(sb, SECTION_SEPARATOR_LINE);
                EmailContentGenerator.appendln(sb, SUBSECTION_SEPARATOR_LINE);
                if (processed) {
                    EmailContentGenerator.appendSampleDetails(sb, String.format("Library processing of sample '%s' was successful.", externalSampleName), sequencingSample);
                    EmailContentGenerator.appendln(sb, SUBSECTION_SEPARATOR_LINE);
                    continue;
                }
                EmailContentGenerator.appendSampleDetails(sb, String.format("Library processing of sample '%s' is possible.", externalSampleName), sequencingSample);
                EmailContentGenerator.appendln(sb, SUBSECTION_SEPARATOR_LINE);
            }
        }

        private static void appendSampleDetails(StringBuilder sb, String heading, Sample sample) {
            EmailContentGenerator.appendln(sb, heading);
            EmailContentGenerator.appendAttribute(sb, PERMLINK_LABEL, sample.getSearchlink());
            EmailContentGenerator.appendAttribute(sb, "Sample identifier", sample.getIdentifier());
            EmailContentGenerator.appendNewline(sb);
            EmailContentGenerator.appendProperties(sb, sample.getProperties());
        }

        private static void appendDataSetsData(StringBuilder sb, List<AbstractExternalData> dataSets) {
            if (dataSets.isEmpty()) {
                return;
            }
            EmailContentGenerator.appendln(sb, SECTION_SEPARATOR_LINE);
            EmailContentGenerator.appendln(sb, SUBSECTION_SEPARATOR_LINE);
            EmailContentGenerator.appendln(sb, "There are new sequencing results available to you.");
            EmailContentGenerator.appendln(sb, SUBSECTION_SEPARATOR_LINE);
            TreeMap sampleMap = new TreeMap();
            List dsList = new ArrayList<AbstractExternalData>();
            for (AbstractExternalData dataSet : dataSets) {
                Sample s = dataSet.getSample();
                if (sampleMap.containsKey(s.getIdentifier())) {
                    dsList = (List)sampleMap.get(s.getIdentifier());
                }
                dsList.add(dataSet);
                sampleMap.put(s.getIdentifier(), dsList);
                dsList = new ArrayList();
            }
            Iterator it = sampleMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pairs = it.next();
                EmailContentGenerator.appendln(sb, String.format("Results for %s", pairs.getKey()));
                dsList = (List)pairs.getValue();
                for (AbstractExternalData ed : dsList) {
                    EmailContentGenerator.appendDataSetDetails(sb, ed);
                }
                it.remove();
                EmailContentGenerator.appendln(sb, SUBSECTION_SEPARATOR_LINE);
            }
        }

        private static void appendDataSetDetails(StringBuilder sb, AbstractExternalData dataSet) {
            Sample flowLaneSample = dataSet.getSample();
            assert (flowLaneSample != null);
            Set<Sample> sequencingSamples = flowLaneSample.getParents();
            assert (sequencingSamples != null);
            String Index1 = EmailContentGenerator.getIndex1(dataSet);
            String Index2 = EmailContentGenerator.getIndex2(dataSet);
            String Index3 = null;
            if (Index1 != null) {
                Index3 = Index1;
            }
            if (Index2 != null) {
                Index3 = String.valueOf(Index3) + "-" + Index2;
            }
            if (Index3 != null) {
                EmailContentGenerator.appendln(sb, "Data Set Type: " + dataSet.getDataSetType().toString() + " Index: " + Index3);
            } else {
                EmailContentGenerator.appendln(sb, "Data Set Type: " + dataSet.getDataSetType().toString());
            }
            EmailContentGenerator.appendln(sb, dataSet.getPermlink());
        }

        private static String getExternalSampleName(Sample sequencingSample) {
            String externalSampleName = EmailContentGenerator.tryGetSamplePropertyValue(sequencingSample, EXTERNAL_SAMPLE_NAME_PROPERTY_CODE);
            assert (externalSampleName != null);
            return externalSampleName;
        }

        private static String getIndex1(AbstractExternalData dataSet) {
            List<IEntityProperty> properties = dataSet.getProperties();
            String Index2 = null;
            for (IEntityProperty p : properties) {
                if (!p.getPropertyType().getCode().equals(INDEX1_PROPERTY_CODE) || (Index2 = p.getVocabularyTerm().getCode()).equals("NOINDEX")) continue;
                return Index2;
            }
            return null;
        }

        private static String getIndex2(AbstractExternalData dataSet) {
            List<IEntityProperty> properties = dataSet.getProperties();
            String Index2 = null;
            for (IEntityProperty p : properties) {
                if (!p.getPropertyType().getCode().equals(INDEX2_PROPERTY_CODE) || (Index2 = p.getVocabularyTerm().getCode()).equals("NOINDEX")) continue;
                return Index2;
            }
            return null;
        }

        private static String tryGetSamplePropertyValue(Sample sequencingSample, String propertyCode) {
            String result = null;
            for (IEntityProperty property : sequencingSample.getProperties()) {
                if (!property.getPropertyType().getCode().equals(propertyCode)) continue;
                result = StringEscapeUtils.unescapeHtml(property.getValue());
                break;
            }
            return result;
        }

        private static void appendProperties(StringBuilder sb, List<IEntityProperty> properties) {
            Collections.sort(properties);
            for (IEntityProperty property : properties) {
                String label = property.getPropertyType().getLabel();
                String valueOrNull = property.tryGetAsString();
                EmailContentGenerator.appendAttribute(sb, label, valueOrNull);
            }
        }

        private static void appendAttribute(StringBuilder sb, String name, String valueOrNull) {
            EmailContentGenerator.appendln(sb, String.format("- %s:\n\t\t%s", StringEscapeUtils.unescapeHtml(name), valueOrNull == null ? "(empty)" : StringEscapeUtils.unescapeHtml(valueOrNull)));
        }

        private static void appendln(StringBuilder sb, String string) {
            sb.append(string);
            EmailContentGenerator.appendNewline(sb);
        }

        private static void appendNewline(StringBuilder sb) {
            sb.append('\n');
        }

        private static String createSeparatorLine(char separatorChar) {
            char[] line = new char[100];
            Arrays.fill(line, separatorChar);
            return new String(line);
        }
    }
}

