/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.filesystem.FileWatcher;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FileWatcherSynchronizer
extends TimerTask {
    private static final ChangeListener[] LISTENER_EMPTY_ARRAY = new ChangeListener[0];
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FileWatcherSynchronizer.class);
    private static FileWatcherSynchronizer instance;
    private final Map<FileWatcher, List<ChangeListener>> fileWatcherListeners = new HashMap<FileWatcher, List<ChangeListener>>();
    private final Map<File, FileWatcher> fileWatchers = new HashMap<File, FileWatcher>();

    public static final synchronized FileWatcherSynchronizer getInstance() {
        if (instance == null) {
            instance = new FileWatcherSynchronizer();
        }
        return instance;
    }

    private final synchronized void fireStateChanged(FileWatcher fileWatcher) {
        ChangeEvent event = new ChangeEvent(fileWatcher.getFileToWatch());
        for (ChangeListener listener : this.fileWatcherListeners.get(fileWatcher)) {
            listener.stateChanged(event);
        }
    }

    public final synchronized void addChangeListener(File file, ChangeListener changeListener) {
        List<ChangeListener> listeners;
        FileWatcher fileWatcher = this.fileWatchers.get(file);
        if (fileWatcher == null) {
            fileWatcher = new FileWatcher(file){

                @Override
                protected final void onChange() {
                    FileWatcherSynchronizer.this.fireStateChanged(this);
                }
            };
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format("A new watcher has been created for file '%s'", file));
            }
            this.fileWatchers.put(file, fileWatcher);
        }
        if ((listeners = this.fileWatcherListeners.get(fileWatcher)) == null) {
            listeners = new ArrayList<ChangeListener>();
            this.fileWatcherListeners.put(fileWatcher, listeners);
        }
        listeners.add(changeListener);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("A new listener has been registered for file '%s'. Currently %d listener(s) registered.", file, listeners.size()));
        }
    }

    public final synchronized void removeChangeListener(File file, ChangeListener changeListener) {
        FileWatcher fileWatcher = this.fileWatchers.get(file);
        if (fileWatcher == null) {
            return;
        }
        List<ChangeListener> listeners = this.fileWatcherListeners.get(fileWatcher);
        if (listeners == null) {
            return;
        }
        listeners.remove(changeListener);
        int size = listeners.size();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("A listener for file '%s' has been removed. Currently %d listener(s) registered.", file, size));
        }
        if (size == 0) {
            this.fileWatchers.remove(file);
        }
    }

    public final synchronized ChangeListener[] getChangeListeners(File file) {
        FileWatcher fileWatcher = this.fileWatchers.get(file);
        if (fileWatcher == null) {
            return null;
        }
        List<ChangeListener> listeners = this.fileWatcherListeners.get(fileWatcher);
        if (listeners == null) {
            return null;
        }
        return listeners.toArray(LISTENER_EMPTY_ARRAY);
    }

    public synchronized void destroy() {
        this.fileWatcherListeners.clear();
        this.fileWatchers.clear();
    }

    @Override
    public final synchronized void run() {
        for (FileWatcher fileWatcher : this.fileWatcherListeners.keySet()) {
            fileWatcher.run();
        }
    }
}

