/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.CopyModeExisting;
import ch.systemsx.cisd.common.filesystem.IFileImmutableCopier;
import ch.systemsx.cisd.common.filesystem.IImmutableCopier;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import org.apache.log4j.Logger;

public final class RecursiveHardLinkMaker
implements IImmutableCopier {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RecursiveHardLinkMaker.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, RecursiveHardLinkMaker.class);
    private final IFileImmutableCopier fileCopier;

    private RecursiveHardLinkMaker(IFileImmutableCopier fileCopier) {
        this.fileCopier = fileCopier;
    }

    public static IImmutableCopier tryCreate(IFileImmutableCopier fileCopierOrNull) {
        if (fileCopierOrNull == null) {
            return null;
        }
        return new RecursiveHardLinkMaker(fileCopierOrNull);
    }

    @Override
    public Status copyImmutably(File source, File destinationDirectory, String nameOrNull) {
        return this.copyImmutably(source, destinationDirectory, nameOrNull, CopyModeExisting.ERROR);
    }

    @Override
    public Status copyImmutably(File source, File destinationDirectory, String nameOrNull, CopyModeExisting mode) {
        assert (source != null && source.exists());
        assert (destinationDirectory != null && destinationDirectory.isDirectory());
        String destName = nameOrNull == null ? source.getName() : nameOrNull;
        File destFile = new File(destinationDirectory, destName);
        if (mode == CopyModeExisting.ERROR && destFile.exists()) {
            String errorMsg = String.format("File '%s' already exists in given destination directory '%s'", destName, destinationDirectory);
            operationLog.error(errorMsg);
            return Status.createError(errorMsg);
        }
        if (operationLog.isTraceEnabled()) {
            operationLog.trace(String.format("Creating a hard link copy of '%s' in '%s'.", source.getPath(), destinationDirectory.getPath()));
        }
        return this.primCopyImmutably(source, destinationDirectory, nameOrNull, mode);
    }

    private final Status primCopyImmutably(File source, File destinationDirectory, String nameOrNull, CopyModeExisting mode) {
        if (source.isFile()) {
            return this.fileCopier.copyFileImmutably(source, destinationDirectory, nameOrNull, mode);
        }
        try {
            File dir = RecursiveHardLinkMaker.createDir(source, destinationDirectory, nameOrNull, mode);
            File[] files = source.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    InterruptedExceptionUnchecked.check();
                    Status stat = this.primCopyImmutably(file, dir, null, mode);
                    if (stat.isError()) {
                        return stat;
                    }
                    ++n2;
                }
            } else if (!source.exists()) {
                operationLog.error(String.format("Path '%s' vanished during processing.", source));
            } else {
                operationLog.error(String.format("Found path '%s' that is neither a file nor a directory.", source));
            }
        }
        catch (IOExceptionUnchecked ex) {
            return Status.createError(ex.getCause().getMessage());
        }
        return Status.OK;
    }

    private static final File createDir(File srcDir, File destDir, String nameOrNull, CopyModeExisting mode) throws IOExceptionUnchecked {
        String name = nameOrNull == null ? srcDir.getName() : nameOrNull;
        File dir = new File(destDir, name);
        boolean ok = dir.mkdir();
        if (!ok) {
            if (dir.isDirectory()) {
                if (mode != CopyModeExisting.ERROR) {
                    return dir;
                }
                String errorMsg = String.format("Directory %s already exists in %s", nameOrNull, destDir.getAbsolutePath());
                machineLog.error(errorMsg);
                throw new IOExceptionUnchecked(errorMsg);
            }
            String errorMsg = String.format("Could not create directory %s inside %s.", nameOrNull, destDir.getAbsolutePath());
            machineLog.error(errorMsg);
            if (dir.isFile()) {
                machineLog.error("There is a file with a same name.");
            }
            throw new IOExceptionUnchecked(errorMsg);
        }
        return dir;
    }
}

