/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jmock.api.ExpectationError;
import org.testng.AssertJUnit;

public class AssertionUtil {
    public static void assertStarts(String expectedPrefix, String text) {
        String errorMsg = String.format("String \n'%s'\nwas expected to start with \n'%s'.", text, expectedPrefix);
        AssertJUnit.assertTrue((String)errorMsg, (boolean)text.startsWith(expectedPrefix));
    }

    public static void assertEnds(String expectedSuffix, String text) {
        String errorMsg = String.format("String \n'%s'\nwas expected to end with \n'%s'.", text, expectedSuffix);
        AssertJUnit.assertTrue((String)errorMsg, (boolean)text.endsWith(expectedSuffix));
    }

    public static void assertContains(String expectedSubstring, String text) {
        String errorMsg = String.format("String \n'%s'\nwas expected to be a substring of \n'%s'.", expectedSubstring, text);
        AssertJUnit.assertTrue((String)errorMsg, (boolean)text.contains(expectedSubstring));
    }

    public static void assertContainsInsensitive(String expectedSubstring, String text) {
        AssertionUtil.assertContains(expectedSubstring.toUpperCase(), text.toUpperCase());
    }

    public static void assertContainsLines(String expected, String actual) {
        Collection<String> expectedLines = AssertionUtil.getLines(expected);
        Collection<String> actualLines = AssertionUtil.getLines(actual);
        actualLines.retainAll(expectedLines);
        AssertJUnit.assertTrue((String)("Expected to contain lines:\n" + expected + "\nactual lines:\n" + actual), (boolean)expectedLines.equals(actualLines));
    }

    public static void assertArraysEqual(int[] a1, int[] a2) {
        AssertJUnit.assertEquals((int)a1.length, (int)a2.length);
        int i = 0;
        while (i < a1.length) {
            AssertJUnit.assertEquals((String)("Different elements at position, " + i), (int)a1[i], (int)a2[i]);
            ++i;
        }
    }

    public static void assertArraysEqual(float[] a1, float[] a2) {
        AssertJUnit.assertEquals((int)a1.length, (int)a2.length);
        int i = 0;
        while (i < a1.length) {
            AssertJUnit.assertEquals((String)("Different elements at position, " + i), (Object)Float.valueOf(a1[i]), (Object)Float.valueOf(a2[i]));
            ++i;
        }
    }

    public static void assertEnumsEqual(List<? extends Enum<?>> values1, List<? extends Enum<?>> values2) {
        Set<String> valuesSet1 = AssertionUtil.asSet(values1);
        Set<String> valuesSet2 = AssertionUtil.asSet(values2);
        AssertJUnit.assertEquals(valuesSet1, valuesSet2);
    }

    private static Set<String> asSet(List<? extends Enum<?>> enumValues) {
        HashSet<String> stringValues = new HashSet<String>();
        for (Enum<?> enumInst : enumValues) {
            stringValues.add(enumInst.name());
        }
        return stringValues;
    }

    private static Collection<String> getLines(String text) {
        if (text == null || text.isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(text.split("\n")));
    }

    public static Throwable tryAsErrorCausedByUnexpectedInvocation(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof ExpectationError) {
            return t;
        }
        return AssertionUtil.tryAsErrorCausedByUnexpectedInvocation(t.getCause());
    }
}

