/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.utils;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.CallableExecutor;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class PreprocessingExecutor {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PreprocessingExecutor.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, PreprocessingExecutor.class);
    private static final PreprocessingExecutor DUMMY = new PreprocessingExecutor(null, 0, 0L, -1L){

        @Override
        public boolean execute(String filePath) {
            return true;
        }

        @Override
        public boolean executeOnce(String filePath) {
            return true;
        }
    };
    public static final String PREPROCESSING_SCRIPT_PATH = "preprocessing-script";
    public static final String PREPROCESSING_SCRIPT_RETRIES = "preprocessing-script-max-retries";
    public static final String PREPROCESSING_SCRIPT_FAILURE_INTERVAL_IN_SEC = "preprocessing-script-failure-interval";
    public static final String PREPROCESSING_SCRIPT_TIMEOUT = "preprocessing-script-timeout-sec";
    private final String preprocessingScriptPath;
    private final int maxRetriesOnFailure;
    private final long millisToSleepOnFailure;
    private final long millisToWaitForCompletion;

    public static PreprocessingExecutor create(Properties properties) {
        String preprocessingScriptPath = properties.getProperty(PREPROCESSING_SCRIPT_PATH);
        int maxRetriesOnFailure = PropertyUtils.getInt(properties, PREPROCESSING_SCRIPT_RETRIES, 0);
        long millisToSleepOnFailure = PropertyUtils.getInt(properties, PREPROCESSING_SCRIPT_FAILURE_INTERVAL_IN_SEC, 0) * 1000;
        long millisToWaitForCompletion = PreprocessingExecutor.extractMillisToWaitForCompletion(properties);
        if (preprocessingScriptPath != null) {
            return new PreprocessingExecutor(preprocessingScriptPath, maxRetriesOnFailure, millisToSleepOnFailure, millisToWaitForCompletion);
        }
        operationLog.info("No preprocessing script found, skipping preprocessing.");
        return DUMMY;
    }

    private static long extractMillisToWaitForCompletion(Properties properties) {
        long timeoutSec = PropertyUtils.getLong(properties, PREPROCESSING_SCRIPT_TIMEOUT, -1L);
        if (timeoutSec == -1L) {
            return -1L;
        }
        return timeoutSec * 1000L;
    }

    private PreprocessingExecutor(String preprocessingScriptPath, int maxRetriesOnFailure, long millisToSleepOnFailure, long millisToWaitForCompletion) {
        this.preprocessingScriptPath = preprocessingScriptPath;
        this.maxRetriesOnFailure = maxRetriesOnFailure;
        this.millisToSleepOnFailure = millisToSleepOnFailure;
        this.millisToWaitForCompletion = millisToWaitForCompletion;
    }

    public boolean execute(final String filePath) {
        Object result = new CallableExecutor(this.maxRetriesOnFailure, this.millisToSleepOnFailure).executeCallable(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                boolean ok = PreprocessingExecutor.this.executeOnce(filePath);
                return ok ? Boolean.valueOf(true) : null;
            }
        });
        return result != null;
    }

    public boolean executeOnce(String filePath) {
        return PreprocessingExecutor.callScript(this.preprocessingScriptPath, this.millisToWaitForCompletion, filePath);
    }

    private static boolean callScript(String scriptPath, long millisToWaitForCompletion, String ... args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(scriptPath);
        cmd.addAll(Arrays.asList(args));
        return ProcessExecutionHelper.runAndLog(cmd, operationLog, machineLog, millisToWaitForCompletion);
    }

    /* synthetic */ PreprocessingExecutor(String string, int n, long l, long l2, PreprocessingExecutor preprocessingExecutor) {
        this(string, n, l, l2);
    }
}

