/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.content;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.PathInfoProviderBasedHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PathInfoDataSourceProvider;
import java.io.File;
import org.apache.log4j.Logger;

public class PathInfoDBAwareHierarchicalContentFactory
extends DefaultFileBasedHierarchicalContentFactory {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PathInfoDBAwareHierarchicalContentFactory.class);
    private final IDataSetPathInfoProvider pathInfoProvider;

    public static IHierarchicalContentFactory create() {
        if (PathInfoDataSourceProvider.isDataSourceDefined()) {
            operationLog.debug("Path Info DB is properly configured");
            return new PathInfoDBAwareHierarchicalContentFactory(ServiceProvider.getDataSetPathInfoProvider());
        }
        operationLog.warn("Path Info DB was NOT configured. File system based implementation will be used.");
        return new DefaultFileBasedHierarchicalContentFactory();
    }

    @Private
    PathInfoDBAwareHierarchicalContentFactory(IDataSetPathInfoProvider pathInfoProvider) {
        this.pathInfoProvider = pathInfoProvider;
    }

    @Override
    public IHierarchicalContent asHierarchicalContent(File file, IDelegatedAction onCloseAction) {
        String dataSetCode = file.getName();
        ISingleDataSetPathInfoProvider dataSetPathInfoProvider = this.pathInfoProvider.tryGetSingleDataSetPathInfoProvider(dataSetCode);
        if (dataSetPathInfoProvider != null) {
            operationLog.debug("Data set " + dataSetCode + " was found in Path Info DB.");
            return new PathInfoProviderBasedHierarchicalContent(dataSetPathInfoProvider, file, onCloseAction);
        }
        operationLog.warn("Data set " + dataSetCode + " was NOT found in Path Info DB. " + "Falling back to file system based implementation.");
        return super.asHierarchicalContent(file, onCloseAction);
    }
}

