/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class ProjectsProvider
extends AbstractCommonTableModelProvider<Project> {
    public ProjectsProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected TypedTableModel<Project> createTableModel() {
        List<Project> projects = this.commonServer.listProjects(this.sessionToken);
        TypedTableModelBuilder<Project> builder = new TypedTableModelBuilder<Project>();
        builder.addColumn("CODE");
        builder.addColumn("SPACE");
        builder.addColumn("DESCRIPTION").withDefaultWidth(200);
        builder.addColumn("REGISTRATOR").withDefaultWidth(200);
        builder.addColumn("MODIFIER").withDefaultWidth(200).hideByDefault();
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        for (Project project : projects) {
            builder.addRow(project);
            builder.column("CODE").addString(project.getCode());
            builder.column("SPACE").addString(project.getSpace().getCode());
            builder.column("DESCRIPTION").addString(project.getDescription());
            builder.column("REGISTRATOR").addPerson(project.getRegistrator());
            builder.column("REGISTRATION_DATE").addDate(project.getRegistrationDate());
            builder.column("MODIFIER").addPerson(project.getModifier());
            builder.column("MODIFICATION_DATE").addDate(project.getModificationDate());
        }
        return builder.getModel();
    }
}

