/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import java.io.Serializable;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public final class GenericHttpSessionListener
implements HttpSessionListener {
    protected static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, GenericHttpSessionListener.class);
    private static final String LOGGING_ACTIVATION_PARAM = "opennis.log.activation.parameter";
    private final HttpSessionActivationListener loggingActivationListener = new LoggingActivationListener();

    public final void sessionCreated(HttpSessionEvent sessionEvent) {
        this.logSessionEvent("sessionCreated", sessionEvent);
        sessionEvent.getSession().setAttribute(LOGGING_ACTIVATION_PARAM, (Object)this.loggingActivationListener);
    }

    public final void sessionDestroyed(HttpSessionEvent sessionEvent) {
        IServer server;
        HttpSession httpSession = sessionEvent.getSession();
        String sessionToken = (String)httpSession.getAttribute("openbis-session-token");
        httpSession.removeAttribute(LOGGING_ACTIVATION_PARAM);
        this.logSessionEvent("sessionDestroyed", sessionEvent);
        if (sessionToken != null && (server = (IServer)httpSession.getAttribute("openbis-server")) != null) {
            if (this.isExpiration(sessionEvent)) {
                server.expireSession(sessionToken);
            } else {
                server.logout(sessionToken);
            }
        }
    }

    private boolean isExpiration(HttpSessionEvent event) {
        HttpSession session;
        long now = System.currentTimeMillis();
        return now - (session = event.getSession()).getLastAccessedTime() > (long)session.getMaxInactiveInterval();
    }

    private void logSessionEvent(String methodName, HttpSessionEvent event) {
        HttpSession session = event.getSession();
        StringBuilder message = new StringBuilder();
        message.append(methodName).append(": ");
        message.append("id=");
        message.append(session.getId());
        message.append(", lastAccessedTime=");
        message.append(session.getLastAccessedTime());
        message.append(", maxInactiveInterval=");
        message.append(session.getMaxInactiveInterval());
        message.append(", attributes=[");
        Enumeration attrNames = session.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            String formattedPropValue = String.format("'%s'='%s', ", attrName, session.getAttribute(attrName));
            message.append((Object)formattedPropValue);
        }
        message.append("]");
        operationLog.info(message.toString());
    }

    private class LoggingActivationListener
    implements HttpSessionActivationListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private LoggingActivationListener() {
        }

        public void sessionWillPassivate(HttpSessionEvent arg0) {
            GenericHttpSessionListener.this.logSessionEvent("sessionWillPassivate", arg0);
        }

        public void sessionDidActivate(HttpSessionEvent arg0) {
            GenericHttpSessionListener.this.logSessionEvent("sessionDidActivate", arg0);
        }
    }
}

