/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.demo.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.plugin.demo.client.web.client.IDemoClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.GenericSampleViewer;
import com.google.gwt.user.client.ui.Widget;

public final class DemoSampleViewer
extends AbstractViewer<Sample> {
    private static final String PREFIX = "demo-sample-viewer_";
    public static final String ID_PREFIX = "openbis_demo-sample-viewer_";
    private final TechId sampleId;

    public DemoSampleViewer(IViewContext<IDemoClientServiceAsync> viewContext, TechId sampleId) {
        super(viewContext, DemoSampleViewer.createId(sampleId));
        this.sampleId = sampleId;
        this.reloadAllData();
    }

    @Override
    protected IViewContext<IDemoClientServiceAsync> getViewContext() {
        return this.viewContext;
    }

    public static final String createId(TechId sampleId) {
        return ID_PREFIX + sampleId;
    }

    private final Widget createUI(SampleParentWithDerived sampleGeneration) {
        return GenericSampleViewer.createPropertyGrid(this.getViewContext(), this.sampleId);
    }

    @Override
    protected void reloadAllData() {
        SampleInfoCallback callback = new SampleInfoCallback(this.getViewContext(), this);
        this.getViewContext().getService().getSampleGenerationInfo(this.sampleId, this.getBaseIndexURL(), callback);
    }

    @Override
    protected String getDeleteButtonLabel() {
        return this.viewContext.getMessage("button_delete_sample", new Object[0]);
    }

    private final class SampleInfoCallback
    extends AbstractAsyncCallback<SampleParentWithDerived> {
        private final DemoSampleViewer sampleViewer;

        private SampleInfoCallback(IViewContext<IDemoClientServiceAsync> viewContext, DemoSampleViewer sampleViewer) {
            super(viewContext);
            this.sampleViewer = sampleViewer;
        }

        @Override
        protected final void process(SampleParentWithDerived result) {
            this.sampleViewer.updateOriginalData(result.getParent());
            this.sampleViewer.removeAll();
            this.sampleViewer.add(this.sampleViewer.createUI(result));
            this.sampleViewer.layout();
        }
    }
}

