/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JsonRpcHttpClient
extends JsonRpcClient {
    private URL serviceUrl;
    private Proxy connectionProxy = Proxy.NO_PROXY;
    private int connectionTimeoutMillis = 60000;
    private int readTimeoutMillis = 120000;
    private Map<String, String> headers = new HashMap<String, String>();

    public JsonRpcHttpClient(ObjectMapper mapper, URL serviceUrl, Map<String, String> headers) {
        super(mapper);
        this.serviceUrl = serviceUrl;
        this.headers.putAll(headers);
    }

    public JsonRpcHttpClient(URL serviceUrl, Map<String, String> headers) {
        this(new ObjectMapper(), serviceUrl, headers);
    }

    public JsonRpcHttpClient(URL serviceUrl) {
        this(new ObjectMapper(), serviceUrl, new HashMap<String, String>());
    }

    public void invoke(String methodName, Object argument) throws Throwable {
        this.invoke(methodName, argument, null, new HashMap<String, String>());
    }

    public Object invoke(String methodName, Object argument, Type returnType) throws Throwable {
        return this.invoke(methodName, argument, returnType, new HashMap<String, String>());
    }

    public <T> T invoke(String methodName, Object argument, Class<T> clazz) throws Throwable {
        return (T)this.invoke(methodName, argument, (Type)Type.class.cast(clazz));
    }

    public Object invoke(String methodName, Object argument, Type returnType, Map<String, String> extraHeaders) throws Throwable {
        HttpURLConnection con = this.openConnection(extraHeaders);
        super.invoke(methodName, argument, con.getOutputStream());
        return super.readResponse(returnType, con.getInputStream());
    }

    public <T> T invoke(String methodName, Object argument, Class<T> clazz, Map<String, String> extraHeaders) throws Throwable {
        return (T)this.invoke(methodName, argument, (Type)Type.class.cast(clazz), extraHeaders);
    }

    private HttpURLConnection openConnection(Map<String, String> extraHeaders) throws IOException {
        HttpURLConnection con = (HttpURLConnection)this.serviceUrl.openConnection(this.connectionProxy);
        con.setConnectTimeout(this.connectionTimeoutMillis);
        con.setReadTimeout(this.readTimeoutMillis);
        con.setAllowUserInteraction(false);
        con.setDefaultUseCaches(false);
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setInstanceFollowRedirects(true);
        con.setRequestMethod("POST");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            con.setRequestProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
            con.setRequestProperty(entry.getKey(), entry.getValue());
        }
        con.setRequestProperty("Content-Type", "application/json-rpc");
        con.connect();
        return con;
    }

    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(URL serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    public void setConnectionProxy(Proxy connectionProxy) {
        this.connectionProxy = connectionProxy;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }
}

