/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.NOPTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedTransformer<I, O>
implements Transformer<I, O>,
Serializable {
    static final long serialVersionUID = 3514945074733160196L;
    private final Transformer[] iTransformers;

    public static <I, O> Transformer<I, O> getInstance(Transformer[] transformers) {
        FunctorUtils.validate(transformers);
        if (transformers.length == 0) {
            return NOPTransformer.INSTANCE;
        }
        transformers = FunctorUtils.copy(transformers);
        return new ChainedTransformer<I, O>(transformers);
    }

    public static <I, O> Transformer<I, O> getInstance(Collection<Transformer> transformers) {
        if (transformers == null) {
            throw new IllegalArgumentException("Transformer collection must not be null");
        }
        if (transformers.size() == 0) {
            return NOPTransformer.INSTANCE;
        }
        Transformer[] cmds = new Transformer[transformers.size()];
        int i = 0;
        Iterator<Transformer> it = transformers.iterator();
        while (it.hasNext()) {
            cmds[i++] = it.next();
        }
        FunctorUtils.validate(cmds);
        return new ChainedTransformer<I, O>(cmds);
    }

    public static <I, M, O> Transformer<I, O> getInstance(Transformer<I, ? extends M> transformer1, Transformer<? super M, O> transformer2) {
        if (transformer1 == null || transformer2 == null) {
            throw new IllegalArgumentException("Transformers must not be null");
        }
        Transformer[] transformers = new Transformer[]{transformer1, transformer2};
        return new ChainedTransformer<I, O>(transformers);
    }

    public ChainedTransformer(Transformer[] transformers) {
        this.iTransformers = transformers;
    }

    @Override
    public O transform(I object) {
        Object intermediate = object;
        int i = 0;
        while (i < this.iTransformers.length) {
            intermediate = this.iTransformers[i].transform(intermediate);
            ++i;
        }
        return (O)intermediate;
    }

    public Transformer[] getTransformers() {
        return this.iTransformers;
    }
}

