/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class DSFRecord
extends Record {
    public static final short sid = 353;
    private short field_1_dsf;

    public DSFRecord() {
    }

    public DSFRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 353) {
            throw new RecordFormatException("NOT A DSF RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_dsf = in.readShort();
    }

    public void setDsf(short dsfflag) {
        this.field_1_dsf = dsfflag;
    }

    public short getDsf() {
        return this.field_1_dsf;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DSF]\n");
        buffer.append("    .isDSF           = ").append(Integer.toHexString(this.getDsf())).append("\n");
        buffer.append("[/DSF]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)353);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getDsf());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 353;
    }
}

