/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml4;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.ncml4.MyCrawlableDataset;
import ucar.nc2.ncml4.Scanner;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScan
implements Scanner {
    protected static Logger logger = LoggerFactory.getLogger(DirectoryScan.class);
    private String dirName;
    private String dateFormatMark;
    private String runMatcher;
    private String forecastMatcher;
    private String offsetMatcher;
    private boolean enhance = false;
    private boolean isDate = false;
    private boolean wantSubdirs = true;
    private String suffix;
    private Pattern regexpPattern = null;
    private long olderThan_msecs;
    private DateFormatter formatter = new DateFormatter();
    private boolean debugScan = false;

    DirectoryScan(AggregationIF.Type type, String dirName, String suffix, String regexpPatternString, String dateFormatMark, String enhanceS, String subdirsS, String olderS) {
        this.dirName = dirName;
        this.suffix = suffix;
        if (null != regexpPatternString) {
            this.regexpPattern = Pattern.compile(regexpPatternString);
        }
        this.dateFormatMark = dateFormatMark;
        if (enhanceS != null && enhanceS.equalsIgnoreCase("true")) {
            this.enhance = true;
        }
        if (subdirsS != null && subdirsS.equalsIgnoreCase("false")) {
            this.wantSubdirs = false;
        }
        if (type == AggregationIF.Type.FORECAST_MODEL_COLLECTION) {
            this.enhance = true;
        }
        if (olderS != null) {
            try {
                TimeUnit tu = new TimeUnit(olderS);
                this.olderThan_msecs = (long)(1000.0 * tu.getValueInSeconds());
            }
            catch (Exception e) {
                logger.error("Invalid time unit for olderThan = {}", (Object)olderS);
            }
        }
        if (dateFormatMark != null) {
            this.isDate = true;
        }
    }

    DirectoryScan(AggregationIF.Type type, String dirName, String suffix, String regexpPatternString, String subdirsS, String olderS, String runMatcher, String forecastMatcher, String offsetMatcher) {
        this(type, dirName, suffix, regexpPatternString, null, "true", subdirsS, olderS);
        this.runMatcher = runMatcher;
        this.forecastMatcher = forecastMatcher;
        this.offsetMatcher = offsetMatcher;
    }

    public boolean isEnhance() {
        return this.enhance;
    }

    public String getDateFormatMark() {
        return this.dateFormatMark;
    }

    public void scanDirectory(List<MyCrawlableDataset> result, CancelTask cancelTask) {
        this.scanDirectory(this.dirName, new Date().getTime(), result, cancelTask);
    }

    private void scanDirectory(String dirName, long now, List<MyCrawlableDataset> result, CancelTask cancelTask) {
        File allDir = new File(dirName);
        if (!allDir.exists()) {
            String tmpMsg = "Non-existent scan location <" + dirName;
            logger.error("scanDirectory(): " + tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
        for (File f : allDir.listFiles()) {
            long lastModified;
            String location = f.getAbsolutePath();
            if (f.isDirectory()) {
                if (this.wantSubdirs) {
                    this.scanDirectory(location, now, result, cancelTask);
                }
            } else if (this.accept(location) && this.olderThan_msecs > 0L && now - (lastModified = f.lastModified()) < this.olderThan_msecs) continue;
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    protected boolean accept(String location) {
        if (null != this.regexpPattern) {
            Matcher matcher = this.regexpPattern.matcher(location);
            return matcher.matches();
        }
        return this.suffix == null || location.endsWith(this.suffix);
    }

    @Override
    public void scanDirectory(Map<String, MyCrawlableDataset> map, CancelTask cancelTask) throws IOException {
    }
}

