/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v1.impl;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.ExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.ISampleImmutable;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.SampleIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class SampleImmutable
implements ISampleImmutable {
    private final Sample sample;
    private final EnumSet<SampleFetchOption> retrievedFetchOptions;
    private final boolean existingSample;

    public SampleImmutable(Sample sample) {
        this(sample, true);
    }

    public SampleImmutable(Sample sample, EnumSet<SampleFetchOption> retrievedFetchOptions) {
        this(sample, retrievedFetchOptions, true);
    }

    public SampleImmutable(Sample sample, boolean existingSample) {
        this(sample, EnumSet.allOf(SampleFetchOption.class), existingSample);
    }

    public SampleImmutable(Sample sample, EnumSet<SampleFetchOption> retrievedFetchOptions, boolean existingSample) {
        this.sample = sample;
        this.retrievedFetchOptions = retrievedFetchOptions;
        this.existingSample = existingSample;
    }

    @Override
    public IExperimentImmutable getExperiment() {
        Experiment experiment = this.sample.getExperiment();
        return experiment != null ? new ExperimentImmutable(experiment) : null;
    }

    @Override
    public String getSampleIdentifier() {
        String identifier = this.sample.getIdentifier();
        return identifier == null ? null : identifier.toUpperCase();
    }

    @Override
    public IObjectId getEntityId() {
        return new SampleIdentifierId(this.getSampleIdentifier());
    }

    public Sample getSample() {
        return this.sample;
    }

    @Override
    public boolean isExistingSample() {
        return this.existingSample;
    }

    protected void checkExists() {
        if (!this.isExistingSample()) {
            throw new UserFailureException("Sample does not exist.");
        }
    }

    @Override
    public String getPropertyValue(String propertyCode) {
        return EntityHelper.tryFindPropertyValue(this.sample, propertyCode);
    }

    @Override
    public String getSampleType() {
        if (this.sample.getSampleType() != null) {
            return this.sample.getSampleType().getCode();
        }
        return null;
    }

    @Override
    public String getSpace() {
        return this.sample.getSpace().getCode();
    }

    @Override
    public String getCode() {
        return this.sample.getCode();
    }

    @Override
    public String getPermId() {
        return this.sample.getPermId();
    }

    @Override
    public List<ISampleImmutable> getContainedSamples() {
        if (!this.canGetContainedSamples()) {
            throw new IllegalStateException("Contained samples were not returned by the server.");
        }
        ArrayList<ISampleImmutable> result = new ArrayList<ISampleImmutable>();
        List<Sample> containedSamples = this.sample.tryGetContainedSamples();
        if (containedSamples != null) {
            for (Sample contained : containedSamples) {
                result.add(new SampleImmutable(contained));
            }
        }
        return result;
    }

    @Override
    public List<String> getParentSampleIdentifiers() {
        ArrayList<String> parentIdentifiers = new ArrayList<String>();
        Set<Sample> sampleParents = this.sample.getParents();
        for (Sample parent : sampleParents) {
            parentIdentifiers.add(parent.getIdentifier());
        }
        return parentIdentifiers;
    }

    @Override
    public boolean canGetContainedSamples() {
        return this.retrievedFetchOptions.contains(SampleFetchOption.CONTAINED);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getSampleIdentifier() == null ? 0 : this.getSampleIdentifier().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        SampleImmutable other = (SampleImmutable)obj;
        return !(this.getSampleIdentifier() == null ? other.getSampleIdentifier() != null : !this.getSampleIdentifier().equals(other.getSampleIdentifier()));
    }
}

