/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.graph;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;

public class TabularDataGraphConfiguration {
    private final GraphType graphType;
    private final String title;
    private final CodeAndLabel xAxisColumn;
    private final CodeAndLabel yAxisColumn;
    private final int imageWidth;
    private final int imageHeight;

    protected TabularDataGraphConfiguration(GraphType graphType, String title, CodeAndLabel xAxisColumn, CodeAndLabel yAxisColumn, int imageWidth, int imageHeight) {
        this.graphType = graphType;
        this.title = title;
        this.xAxisColumn = xAxisColumn;
        this.yAxisColumn = yAxisColumn;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    public String getTitle() {
        return this.title;
    }

    public GraphType getGraphType() {
        return this.graphType;
    }

    protected CodeAndLabel getXAxisColumn() {
        return this.xAxisColumn;
    }

    protected CodeAndLabel getYAxisColumn() {
        return this.yAxisColumn;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public String getXLabel() {
        return this.xAxisColumn.getLabel();
    }

    public String getYLabel() {
        return this.yAxisColumn.getLabel();
    }

    public static enum GraphType {
        SCATTERPLOT,
        HISTOGRAM,
        HEATMAP;

    }
}

