/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ProjectLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.attachment.AttachmentDownloadHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.IAttachmentHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class AttachmentDownloadLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public AttachmentDownloadLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        super("DOWNLOAD_ATTACHMENT");
        this.viewContext = viewContext;
    }

    @Override
    public void resolve(ViewLocator locator) throws UserFailureException {
        String entityKindValueOrNull = locator.tryGetEntity();
        AttachmentDownloadLocatorResolver.checkRequiredParameter(entityKindValueOrNull, "entity");
        AttachmentHolderKind attachmentHolderKind = this.getAttachmentHolderKind(entityKindValueOrNull);
        String fileNameOrNull = locator.getParameters().get("file");
        String versionOrNull = locator.getParameters().get("version");
        AttachmentDownloadLocatorResolver.checkRequiredParameter(fileNameOrNull, "file");
        try {
            Integer version = null;
            if (versionOrNull != null) {
                version = Integer.parseInt(versionOrNull);
            }
            if (attachmentHolderKind == AttachmentHolderKind.PROJECT) {
                BasicProjectIdentifier projectIdentifier = ProjectLocatorResolver.extractProjectIdentifier(locator);
                this.downloadProjectAttachment(projectIdentifier, fileNameOrNull, version);
            } else {
                String permIdValueOrNull = locator.getParameters().get("permId");
                AttachmentDownloadLocatorResolver.checkRequiredParameter(permIdValueOrNull, "permId");
                EntityKind entityKind = AttachmentDownloadLocatorResolver.getEntityKind(locator);
                this.downloadAttachment(entityKind, attachmentHolderKind, permIdValueOrNull, fileNameOrNull, version);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new UserFailureException("URL parameter 'version' value is expected to be a number.");
        }
    }

    private void downloadAttachment(EntityKind entityKind, AttachmentHolderKind attachmentHolderKind, String permId, String fileName, Integer version) {
        this.viewContext.getService().getEntityInformationHolder(entityKind, permId, new AttachmentDownloadCallback(this.viewContext, attachmentHolderKind, fileName, version));
    }

    private void downloadProjectAttachment(BasicProjectIdentifier identifier, String fileName, Integer version) throws UserFailureException {
        this.viewContext.getService().getProjectInfo(identifier, (AsyncCallback<Project>)new ProjectAttachmentDownloadCallback(this.viewContext, fileName, version));
    }

    private AttachmentHolderKind getAttachmentHolderKind(String entityKind) {
        try {
            return AttachmentHolderKind.valueOf(entityKind);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UserFailureException("Invalid 'entity' URL parameter value.");
        }
    }

    private static class AttachmentDownloadCallback
    extends AbstractAsyncCallback<IEntityInformationHolderWithPermId> {
        private final AttachmentHolderKind attachmentHolderKind;
        private final String fileName;
        private final Integer version;

        private AttachmentDownloadCallback(IViewContext<?> viewContext, AttachmentHolderKind attachmentHolderKind, String fileName, Integer version) {
            super(viewContext);
            this.attachmentHolderKind = attachmentHolderKind;
            this.fileName = fileName;
            this.version = version;
        }

        @Override
        public void process(IEntityInformationHolderWithPermId result) {
            AttachmentDownloadHelper.download(this.fileName, this.version, this.createAttachmentHolder(result));
        }

        private IAttachmentHolder createAttachmentHolder(final IEntityInformationHolder result) {
            return new IAttachmentHolder(){

                @Override
                public AttachmentHolderKind getAttachmentHolderKind() {
                    return AttachmentDownloadCallback.this.attachmentHolderKind;
                }

                @Override
                public Long getId() {
                    return result.getId();
                }

                @Override
                public String getCode() {
                    return result.getCode();
                }
            };
        }
    }

    private static class ProjectAttachmentDownloadCallback
    extends AbstractAsyncCallback<Project> {
        private final String fileName;
        private final Integer version;

        private ProjectAttachmentDownloadCallback(IViewContext<?> viewContext, String fileName, Integer version) {
            super(viewContext);
            this.fileName = fileName;
            this.version = version;
        }

        @Override
        protected final void process(Project result) {
            AttachmentDownloadHelper.download(this.fileName, this.version, result);
        }
    }
}

