/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.cifex.rpc.FilePreregistrationDTO;
import ch.systemsx.cisd.cifex.server.business.FileInformation;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.PreCreatedFileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.FileContent;
import ch.systemsx.cisd.cifex.server.business.dto.FileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogAnnotation;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public interface IFileManager {
    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public FileInformation getFileInformation(long var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public FileInformation getFileInformationFilestoreUnimportant(long var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public boolean isAllowedAccess(UserDTO var1, FileDTO var2);

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public boolean isControlling(UserDTO var1, FileDTO var2);

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public List<FileDTO> listFiles();

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public List<FileDTO> listDownloadFiles(long var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION, logLevel=LogLevel.TRACE)
    public List<FileDTO> listOwnedFiles(long var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public FileContent getFileContent(FileDTO var1) throws IllegalStateException;

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public FileDTO saveFile(UserDTO var1, String var2, String var3, String var4, InputStream var5);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public FileDTO saveFile(UserDTO var1, String var2, String var3, String var4, long var5, InputStream var7);

    public void resumeSaveFile(UserDTO var1, FileDTO var2, File var3, String var4, long var5, InputStream var7) throws IllegalArgumentException;

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public List<String> registerFileLinkAndInformRecipients(UserDTO var1, String var2, String var3, String var4, File var5, int var6, String[] var7, String var8, IUserActionLog var9);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public void updateUploadProgress(FileDTO var1, UserDTO var2);

    public FileDTO tryGetUploadResumeCandidate(long var1, String var3, long var4);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public List<String> shareFilesWith(String var1, UserDTO var2, Collection<String> var3, Collection<FileDTO> var4, String var5, IUserActionLog var6) throws UserFailureException;

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public void deleteFile(FileDTO var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public File createFile(UserDTO var1, String var2);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public PreCreatedFileDTO createFile(UserDTO var1, FilePreregistrationDTO var2, String var3);

    public void throwExceptionOnFileDoesNotExist(String var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public void deleteExpiredFiles(IUserActionLog var1);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public Date updateFileUserData(long var1, String var3, String var4, Date var5, UserDTO var6);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public void updateFile(FileDTO var1, UserDTO var2);

    @LogAnnotation(logCategory=LogCategory.TRACKING)
    public void deleteSharingLink(long var1, String var3);

    @LogAnnotation(logCategory=LogCategory.OPERATION)
    public FileDTO getFile(long var1) throws IllegalArgumentException;

    public File getRealFile(FileDTO var1);
}

