/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SIZE
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(SIZE.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        String fileName = request.getArgument();
        if (fileName == null) {
            session.write(LocalizedFtpReply.translate(session, request, context, 501, "SIZE", null));
            return;
        }
        FtpFile file = null;
        try {
            file = session.getFileSystemView().getFile(fileName);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception getting file object", (Throwable)ex);
        }
        if (file == null) {
            session.write(LocalizedFtpReply.translate(session, request, context, 550, "SIZE.missing", fileName));
            return;
        }
        fileName = file.getAbsolutePath();
        if (!file.doesExist()) {
            session.write(LocalizedFtpReply.translate(session, request, context, 550, "SIZE.missing", fileName));
        } else if (!file.isFile()) {
            session.write(LocalizedFtpReply.translate(session, request, context, 550, "SIZE.invalid", fileName));
        } else {
            String fileLen = String.valueOf(file.getSize());
            session.write(LocalizedFtpReply.translate(session, request, context, 213, "SIZE", fileLen));
        }
    }
}

