/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.lemnik.eodsql.AutoGeneratedKeys;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.spi.util.MutableColumn;

class MutableField
implements MutableColumn {
    private final String columnName;
    private final Field field;

    MutableField(String string, Field field, boolean bl) {
        this.columnName = string;
        this.field = field;
        if (!Modifier.isPublic(field.getModifiers()) && bl) {
            field.setAccessible(true);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void set(Object object, Object object2) throws EoDException {
        try {
            this.field.set(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EoDException("Cannot assign value to field: " + this, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EoDException("Cannot assign value to field: " + this, illegalAccessException);
        }
    }

    public Object get(Object object) throws EoDException {
        try {
            return this.field.get(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EoDException("Cannot get value from field: " + this, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EoDException("Cannot get value from field: " + this, illegalAccessException);
        }
    }

    public Class getType() {
        return this.field.getType();
    }

    public String toString() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName();
    }

    public boolean isAutoKey() {
        return this.field.isAnnotationPresent(AutoGeneratedKeys.class);
    }
}

