/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.DatasetAuthorizationCache;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.IDssSessionAuthorizer;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.List;
import org.apache.log4j.Logger;

public class DatasetSessionAuthorizer
implements IDssSessionAuthorizer {
    private static final int MILLIS_PER_MINUTE = 60000;
    protected static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DatasetSessionAuthorizer.class);
    private final DatasetAuthorizationCache authCacheOrNull;

    public DatasetSessionAuthorizer() {
        this(5, 180);
    }

    public DatasetSessionAuthorizer(int cacheExpirationMins, int cleanupTimerMins) {
        this.authCacheOrNull = cacheExpirationMins == 0 ? null : new DatasetAuthorizationCache(cacheExpirationMins * 60000, cleanupTimerMins * 60000);
    }

    @Override
    public Status checkDatasetAccess(String sessionToken, List<String> datasetCodes) {
        Status cachedStatus = this.tryGetCached(sessionToken, datasetCodes);
        if (cachedStatus != null) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format("Access of session '%s' to data sets '%s' on openBIS application server (from authorization cache): %s.", sessionToken, datasetCodes, cachedStatus));
            }
            return cachedStatus;
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Checking access of session '%s' to data sets '%s' on openBIS application server.", sessionToken, datasetCodes));
        }
        IEncapsulatedOpenBISService openBISService = ServiceProvider.getOpenBISService();
        try {
            openBISService.checkDataSetCollectionAccess(sessionToken, datasetCodes);
            this.cachePutAll(sessionToken, datasetCodes, true);
            return Status.OK;
        }
        catch (UserFailureException ex) {
            if (datasetCodes.size() == 1) {
                this.cachePut(sessionToken, datasetCodes.get(0), false);
            }
            return Status.createError(ex.getMessage());
        }
    }

    @Override
    public Status checkDatasetAccess(String sessionToken, String datasetCode) {
        Status cachedStatus = this.tryGetCached(sessionToken, datasetCode);
        if (cachedStatus != null) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format("Access of session '%s' to data set '%s' on openBIS application server (from authorization cache): %s.", sessionToken, datasetCode, cachedStatus));
            }
            return cachedStatus;
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Checking access of session '%s' to data set '%s' on openBIS application server.", sessionToken, datasetCode));
        }
        IEncapsulatedOpenBISService openBISService = ServiceProvider.getOpenBISService();
        try {
            openBISService.checkDataSetAccess(sessionToken, datasetCode);
            this.cachePut(sessionToken, datasetCode, true);
            return Status.OK;
        }
        catch (UserFailureException ex) {
            this.cachePut(sessionToken, datasetCode, false);
            return Status.createError(ex.getMessage());
        }
    }

    @Override
    public Status checkSpaceWriteable(String sessionToken, SpaceIdentifier spaceId) {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Checking whether space '%s' is writable to session '%s' on openBIS application server.", spaceId, sessionToken));
        }
        IEncapsulatedOpenBISService openBISService = ServiceProvider.getOpenBISService();
        try {
            openBISService.checkSpaceAccess(sessionToken, spaceId);
            return Status.OK;
        }
        catch (UserFailureException ex) {
            return Status.createError(ex.getMessage());
        }
    }

    @Override
    public Status checkInstanceAdminAuthorization(String sessionToken) {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Checking if session '%s' has instance admin privileges on openBIS application server.", sessionToken));
        }
        IEncapsulatedOpenBISService openBISService = ServiceProvider.getOpenBISService();
        try {
            openBISService.checkInstanceAdminAuthorization(sessionToken);
            return Status.OK;
        }
        catch (UserFailureException ex) {
            return Status.createError(ex.getMessage());
        }
    }

    @Override
    public Status checkSpacePowerUserAuthorization(String sessionToken) {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Checking if session '%s' has space power user privileges on openBIS application server.", sessionToken));
        }
        IEncapsulatedOpenBISService openBISService = ServiceProvider.getOpenBISService();
        try {
            openBISService.checkSpacePowerUserAuthorization(sessionToken);
            return Status.OK;
        }
        catch (UserFailureException ex) {
            return Status.createError(ex.getMessage());
        }
    }

    public void clearCache() {
        if (this.authCacheOrNull == null) {
            return;
        }
        this.authCacheOrNull.clear();
    }

    private void cachePut(String sessionToken, String datasetCode, boolean authorized) {
        if (this.authCacheOrNull == null) {
            return;
        }
        this.authCacheOrNull.put(sessionToken, datasetCode, authorized);
    }

    private void cachePutAll(String sessionToken, List<String> datasetCodes, boolean authorized) {
        if (this.authCacheOrNull == null) {
            return;
        }
        this.authCacheOrNull.putAll(sessionToken, datasetCodes, authorized);
    }

    private Status tryGetCached(String sessionToken, String datasetCode) {
        if (this.authCacheOrNull == null) {
            return null;
        }
        Boolean authorized = this.authCacheOrNull.tryGet(sessionToken, datasetCode);
        return authorized == null ? null : (authorized != false ? Status.OK : Status.createError());
    }

    private Status tryGetCached(String sessionToken, List<String> datasetCodes) {
        if (this.authCacheOrNull == null) {
            return null;
        }
        for (String code : datasetCodes) {
            Boolean authorized = this.authCacheOrNull.tryGet(sessionToken, code);
            if (authorized == null) {
                return null;
            }
            if (authorized.booleanValue()) continue;
            return Status.createError();
        }
        return Status.OK;
    }
}

