/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModuleInitializationObserver;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;

public class ModuleInitializationController {
    private static ModuleInitializationController INSTANCE;
    private int remainingModulesCounter;
    private final List<IModule> successfullyInitializedModules = new ArrayList<IModule>();
    private final List<IModule> uninitializedModules = new ArrayList<IModule>();
    private final List<IModuleInitializationObserver> observers = new ArrayList<IModuleInitializationObserver>();

    public static void cleanup() {
        INSTANCE = null;
    }

    public static ModuleInitializationController createAndInitialize(List<IModule> modules) {
        if (INSTANCE == null) {
            INSTANCE = new ModuleInitializationController(modules);
            for (IModule module : modules) {
                module.initialize(new ModuleInitializationCallback(INSTANCE, module));
            }
        }
        return INSTANCE;
    }

    public void addObserver(IModuleInitializationObserver observer) {
        if (this.remainingModulesCounter != 0) {
            this.observers.add(observer);
        } else {
            observer.notify(this.successfullyInitializedModules);
        }
    }

    private ModuleInitializationController(List<IModule> allModules) {
        this.successfullyInitializedModules.addAll(allModules);
        this.remainingModulesCounter = allModules.size();
    }

    private void onInitializationFailure(Throwable caught, IModule module) {
        this.successfullyInitializedModules.remove(module);
        this.uninitializedModules.add(module);
        this.onModuleInitializationComplete();
    }

    private void onInitializationSuccess(IModule module) {
        this.onModuleInitializationComplete();
    }

    private void onModuleInitializationComplete() {
        --this.remainingModulesCounter;
        if (this.remainingModulesCounter == 0) {
            for (IModuleInitializationObserver observer : this.observers) {
                observer.notify(this.successfullyInitializedModules);
            }
            this.showErrorMessageIfNecessary();
        }
    }

    private void showErrorMessageIfNecessary() {
        if (this.uninitializedModules.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Initialization of these utilities failed: ");
        for (IModule module : this.uninitializedModules) {
            sb.append(String.valueOf(module.getName()) + ", ");
        }
        sb.setLength(sb.length() - 2);
        MessageBox.alert((String)"Error", (String)sb.toString(), null);
    }

    private static class ModuleInitializationCallback
    implements AsyncCallback<Void> {
        private final ModuleInitializationController controller;
        private final IModule module;

        public ModuleInitializationCallback(ModuleInitializationController controller, IModule module) {
            this.controller = controller;
            this.module = module;
        }

        public void onFailure(Throwable caught) {
            this.controller.onInitializationFailure(caught, this.module);
        }

        public void onSuccess(Void result) {
            this.controller.onInitializationSuccess(this.module);
        }
    }
}

