/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.WebAppSettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DisplaySettingsProvider {
    private final Map<String, DisplaySettings> displaySettingsMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Lock> locksMap = Collections.synchronizedMap(new HashMap());

    public void addDisplaySettingsForPerson(final PersonPE person) {
        this.executeActionWithPersonLock(person, new IDelegatedActionWithResult<Void>(){

            @Override
            public Void execute(boolean didOperationSucceed) {
                DisplaySettings settings = (DisplaySettings)DisplaySettingsProvider.this.displaySettingsMap.get(person.getUserId());
                if (settings == null) {
                    settings = person.getDisplaySettings();
                    DisplaySettingsProvider.this.displaySettingsMap.put(person.getUserId(), settings);
                }
                return null;
            }
        });
    }

    public DisplaySettings getCurrentDisplaySettings(final PersonPE person) {
        return this.executeActionWithPersonLock(person, new IDelegatedActionWithResult<DisplaySettings>(){

            @Override
            public DisplaySettings execute(boolean didOperationSucceed) {
                DisplaySettings settings = (DisplaySettings)DisplaySettingsProvider.this.displaySettingsMap.get(person.getUserId());
                if (settings == null) {
                    settings = person.getDisplaySettings();
                    DisplaySettingsProvider.this.displaySettingsMap.put(person.getUserId(), settings);
                }
                settings = new DisplaySettings(settings);
                return settings;
            }
        });
    }

    public DisplaySettings getRegularDisplaySettings(final PersonPE person) {
        return this.executeActionWithPersonLock(person, new IDelegatedActionWithResult<DisplaySettings>(){

            @Override
            public DisplaySettings execute(boolean didOperationSucceed) {
                DisplaySettings settings = (DisplaySettings)DisplaySettingsProvider.this.displaySettingsMap.get(person.getUserId());
                if (settings == null) {
                    settings = person.getDisplaySettings();
                    DisplaySettingsProvider.this.displaySettingsMap.put(person.getUserId(), settings);
                }
                settings = new DisplaySettings(settings);
                settings.clearCustomWebAppSettings();
                return settings;
            }
        });
    }

    public DisplaySettings replaceCurrentDisplaySettings(final PersonPE person, final DisplaySettings settings) {
        return this.executeActionWithPersonLock(person, new IDelegatedActionWithResult<DisplaySettings>(){

            @Override
            public DisplaySettings execute(boolean didOperationSucceed) {
                DisplaySettingsProvider.this.displaySettingsMap.put(person.getUserId(), settings);
                person.setDisplaySettings(settings);
                return settings;
            }
        });
    }

    public DisplaySettings replaceRegularDisplaySettings(final PersonPE person, final DisplaySettings settings) {
        return this.executeActionWithPersonLock(person, new IDelegatedActionWithResult<DisplaySettings>(){

            @Override
            public DisplaySettings execute(boolean didOperationSucceed) {
                DisplaySettings oldSettings = (DisplaySettings)DisplaySettingsProvider.this.displaySettingsMap.get(person.getUserId());
                if (oldSettings != null) {
                    settings.overwriteCustomWebAppSettings(oldSettings);
                    settings.overwriteColumnSettings(oldSettings);
                }
                DisplaySettingsProvider.this.displaySettingsMap.put(person.getUserId(), settings);
                person.setDisplaySettings(settings);
                return settings;
            }
        });
    }

    public WebAppSettings getWebAppSettings(final PersonPE person, final String webAppId) {
        return this.executeActionWithPersonLock(person, new IDelegatedActionWithResult<WebAppSettings>(){

            @Override
            public WebAppSettings execute(boolean didOperationSucceed) {
                DisplaySettings settings = (DisplaySettings)DisplaySettingsProvider.this.displaySettingsMap.get(person.getUserId());
                if (settings == null) {
                    settings = person.getDisplaySettings();
                    DisplaySettingsProvider.this.displaySettingsMap.put(person.getUserId(), settings);
                }
                return new WebAppSettings(webAppId, settings.getCustomWebAppSettings(webAppId));
            }
        });
    }

    public DisplaySettings replaceWebAppSettings(final PersonPE person, final WebAppSettings webAppSettings) {
        return this.executeActionWithPersonLock(person, new IDelegatedActionWithResult<DisplaySettings>(){

            @Override
            public DisplaySettings execute(boolean didOperationSucceed) {
                DisplaySettings settings = (DisplaySettings)DisplaySettingsProvider.this.displaySettingsMap.get(person.getUserId());
                if (settings == null) {
                    settings = person.getDisplaySettings();
                    DisplaySettingsProvider.this.displaySettingsMap.put(person.getUserId(), settings);
                }
                settings.setCustomWebAppSettings(webAppSettings.getWebAppId(), webAppSettings.getSettings());
                person.setDisplaySettings(settings);
                return settings;
            }
        });
    }

    public <T> T executeActionWithPersonLock(PersonPE person, IDelegatedActionWithResult<T> action) {
        Lock lock = this.getPersonLock(person);
        lock.lock();
        try {
            T t = action.execute(true);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private synchronized Lock getPersonLock(PersonPE person) {
        Lock lock = this.locksMap.get(person.getUserId());
        if (lock == null) {
            lock = new ReentrantLock();
            this.locksMap.put(person.getUserId(), lock);
        }
        return lock;
    }
}

