/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import java.util.HashMap;
import java.util.Map;

public final class ValidatorStore {
    private static final Map<Class<? extends IValidator<?>>, IValidator<?>> store = new HashMap();

    private ValidatorStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <V extends IValidator<T>, T> IValidator<T> getValidatorForClass(Class<V> validatorClass, IAuthorizationDataProvider authorizationDataProvider) {
        Map<Class<? extends IValidator<?>>, IValidator<?>> map = store;
        synchronized (map) {
            IValidator validator = ValidatorStore.cast(store.get(validatorClass));
            if (validator == null) {
                validator = (IValidator)ClassUtils.createInstance(validatorClass);
                validator.init(authorizationDataProvider);
                store.put(validatorClass, validator);
            }
            return validator;
        }
    }

    private static final <T> IValidator<T> cast(IValidator<?> validator) {
        return validator;
    }
}

