/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.coreplugin;

import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.server.coreplugin.JettyWebAppPluginInjector;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImport;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsInjector;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsUtils;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.IPluginType;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.PluginType;
import java.io.IOException;
import java.util.Properties;

public class CorePluginsInjectingPropertyPlaceholderConfigurer
extends ExposablePropertyPlaceholderConfigurer {
    static final PluginType PLUGIN_TYPE_WEBAPPS = new PluginType("webapps", "webapps");

    protected void loadProperties(Properties properties) throws IOException {
        super.loadProperties(properties);
        CorePluginsUtils.addCorePluginsProperties(properties, CorePluginScanner.ScannerType.AS);
        PluginType dssDataSources = this.createPluginTypeDssDataSources();
        PluginType maintenanceTasks = new PluginType("maintenance-tasks", "maintenance-plugins");
        PluginType customImports = new PluginType("custom-imports", CustomImport.PropertyNames.CUSTOM_IMPORTS.getName());
        PluginType queryDatabases = new PluginType("query-databases", "query-databases");
        PluginType miscellaneous = new PluginType("miscellaneous", null);
        PluginType webapps = PLUGIN_TYPE_WEBAPPS;
        new CorePluginsInjector(CorePluginScanner.ScannerType.AS, new IPluginType[]{maintenanceTasks, customImports, queryDatabases, miscellaneous, dssDataSources, webapps}).injectCorePlugins(properties);
        new JettyWebAppPluginInjector(properties).injectWebApps();
    }

    private PluginType createPluginTypeDssDataSources() {
        return new PluginType("dss-data-sources", "dss-based-data-source-provider.data-store-servers"){

            @Override
            public String getPluginKey(String technology, String pluginFolderName, Properties properties) {
                String actualTechnology = properties.getProperty("technology", technology);
                return String.valueOf(pluginFolderName) + "[" + actualTechnology + "]";
            }

            @Override
            public String getPrefix() {
                return "dss-based-data-source-provider.";
            }
        };
    }
}

