/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumnGroup;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.resultset.ScreeningProviderMessages;
import ch.systemsx.cisd.openbis.plugin.screening.shared.IScreeningServer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialBiologicalReplicateFeatureSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaFeatureSummary;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaFeatureSummaryResult;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaSummaryAggregationType;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import java.util.List;

public class MaterialReplicaFeatureSummaryProvider
extends AbstractTableModelProvider<MaterialReplicaFeatureSummary> {
    private static final String DEFAULT_SUBGROUP = "DEFAULT_SUBGROUP-";
    private final IScreeningServer server;
    private final String sessionToken;
    private final WellSearchCriteria.MaterialFeaturesOneExpCriteria criteria;

    public MaterialReplicaFeatureSummaryProvider(IScreeningServer server, String sessionToken, WellSearchCriteria.MaterialFeaturesOneExpCriteria criteria) {
        this.server = server;
        this.sessionToken = sessionToken;
        this.criteria = criteria;
    }

    @Override
    public TypedTableModel<MaterialReplicaFeatureSummary> createTableModel() {
        TypedTableModelBuilder<MaterialReplicaFeatureSummary> builder = new TypedTableModelBuilder<MaterialReplicaFeatureSummary>();
        MaterialReplicaFeatureSummaryResult replicaResult = this.server.getMaterialFeatureVectorSummary(this.sessionToken, this.criteria);
        List<MaterialReplicaFeatureSummary> rows = replicaResult.getFeatureSummaries();
        boolean displayMedianAndDeviation = this.shouldDisplayMedianAndDeviationColumns(rows);
        builder.addColumn("FEATURE");
        if (displayMedianAndDeviation) {
            builder.addColumn("MEDIAN").withDataType(DataTypeCode.REAL);
            builder.addColumn("DEVIATION").withDataType(DataTypeCode.REAL);
        }
        String rankTitle = ScreeningProviderMessages.getRankColumnHeader(replicaResult.getNumberOfMaterialsInExperiment());
        builder.addColumn("RANK").withDataType(DataTypeCode.INTEGER).withTitle(rankTitle);
        List<String> subgroupLabels = replicaResult.getSubgroupLabels();
        if (rows.isEmpty()) {
            return builder.getModel();
        }
        for (String subgroup : subgroupLabels) {
            builder.columnGroup(subgroup);
        }
        if (rows.get(0).getDirectTechnicalReplicates() != null) {
            builder.columnGroup(DEFAULT_SUBGROUP);
        }
        for (MaterialReplicaFeatureSummary row : rows) {
            this.addRow(builder, row, subgroupLabels, displayMedianAndDeviation);
        }
        return builder.getModel();
    }

    private boolean shouldDisplayMedianAndDeviationColumns(List<MaterialReplicaFeatureSummary> rows) {
        return !this.hasOnlyOneReplica(rows);
    }

    private boolean hasOnlyOneReplica(List<MaterialReplicaFeatureSummary> rows) {
        for (MaterialReplicaFeatureSummary row : rows) {
            List<MaterialBiologicalReplicateFeatureSummary> allSubgroups = row.getBiologicalRelicates();
            MaterialBiologicalReplicateFeatureSummary defaultSubGroup = row.getDirectTechnicalReplicates();
            allSubgroups.add(defaultSubGroup);
            if (allSubgroups.size() > 1) {
                return false;
            }
            if (allSubgroups.size() != 1 || allSubgroups.get(0).getFeatureValues().length <= 1) continue;
            return false;
        }
        return true;
    }

    private void addRow(TypedTableModelBuilder<MaterialReplicaFeatureSummary> builder, MaterialReplicaFeatureSummary row, List<String> subgroupLabels, boolean displayMedianAndDeviation) {
        MaterialBiologicalReplicateFeatureSummary defaultSubgroup;
        builder.addRow(row);
        builder.column("FEATURE").addString(row.getFeatureDescription().getLabel());
        builder.column("RANK").addInteger(Long.valueOf(row.getFeatureVectorRank()));
        if (displayMedianAndDeviation) {
            builder.column("MEDIAN").addDouble(row.getFeatureVectorSummary());
            builder.column("DEVIATION").addDouble(row.getFeatureVectorDeviation());
        }
        if ((defaultSubgroup = row.getDirectTechnicalReplicates()) != null) {
            this.addSubgroup(builder, DEFAULT_SUBGROUP, "", defaultSubgroup);
        }
        int numSubgroups = subgroupLabels.size();
        List<MaterialBiologicalReplicateFeatureSummary> subgroups = row.getBiologicalRelicates();
        int i = 0;
        while (i < numSubgroups) {
            String subgroupLabel = subgroupLabels.get(i);
            MaterialBiologicalReplicateFeatureSummary subgroup = subgroups.get(i);
            this.addSubgroup(builder, subgroupLabel, subgroupLabel, subgroup);
            ++i;
        }
    }

    private void addSubgroup(TypedTableModelBuilder<MaterialReplicaFeatureSummary> builder, String groupId, String groupLabel, MaterialBiologicalReplicateFeatureSummary subgroup) {
        IColumnGroup columnGroup = builder.columnGroup(groupId);
        float[] featureValues = subgroup.getFeatureValues();
        int numberFeatures = featureValues.length;
        int i = 0;
        while (i < numberFeatures) {
            String replicaColumnId = this.getReplicaColumnId(groupLabel, i);
            String replicaColumnTitle = ScreeningProviderMessages.getReplicaColumnTitle(groupLabel, i + 1, numberFeatures);
            columnGroup.column(replicaColumnId).withDataType(DataTypeCode.REAL).withTitle(replicaColumnTitle).addDouble(Double.valueOf(featureValues[i]));
            ++i;
        }
        if (!DEFAULT_SUBGROUP.equals(groupId) && numberFeatures > 1) {
            MaterialReplicaSummaryAggregationType aggregationType = subgroup.getSummaryAggregationType();
            String aggreationColumnId = this.getAggreationColumnId(groupLabel, aggregationType);
            String aggreationColumnTitle = this.getAggreationColumnTitle(groupLabel, aggregationType);
            columnGroup.column(aggreationColumnId).withDataType(DataTypeCode.REAL).withTitle(aggreationColumnTitle).addDouble(Double.valueOf(subgroup.getAggregatedSummary()));
        }
    }

    private String getAggreationColumnId(String group, MaterialReplicaSummaryAggregationType summaryAggregationType) {
        return String.valueOf(group) + ":" + summaryAggregationType.name().toLowerCase();
    }

    private String getAggreationColumnTitle(String group, MaterialReplicaSummaryAggregationType aggregationType) {
        return String.valueOf(group) + " " + aggregationType.name().toLowerCase();
    }

    private String getReplicaColumnId(String group, int replicaIdx) {
        return String.valueOf(group) + ":" + replicaIdx;
    }
}

