/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ch.systemsx.sybit.imageviewer.data.ImageHandler;
import ch.systemsx.sybit.imageviewer.data.SettingsUtil;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import ch.systemsx.sybit.imageviewer.gui.ImagesList;
import ch.systemsx.sybit.imageviewer.processors.ImageUtil;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImagesListPanel
extends JScrollPane
implements ListSelectionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private ImagesList list;
    private DefaultListModel listModel;
    private ImageViewer imageViewer;
    private boolean wasSelected;

    public ImagesListPanel(ImageViewer imageViewer, int mode) {
        this.imageViewer = imageViewer;
        this.listModel = new DefaultListModel();
        for (ImageHandler image : imageViewer.getImages()) {
            this.listModel.addElement(ImageUtil.getScaledImageIcon(image.getImage().getBufferedImage(), 50, 50, this));
        }
        this.list = new ImagesList(imageViewer, this.listModel);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        this.list.setVisibleRowCount(1);
        this.list.setLayoutOrientation(2);
        this.setViewportView(this.list);
        this.setHorizontalScrollBarPolicy(30);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.setPreferredSize(new Dimension(imageViewer.getMaxImageWidth(), 80));
        if (mode == SettingsUtil.LocalSystem) {
            this.list.addKeyListener(this);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.list.getSelectedIndex() != this.imageViewer.getCurrentImageId() && this.list.getSelectedIndex() != -1 && this.imageViewer.getImages().size() > 0) {
            if (this.imageViewer.getImages().get(this.imageViewer.getCurrentImageId()).getFullSizeImage() != null) {
                this.imageViewer.getImages().get(this.imageViewer.getCurrentImageId()).setFullSizeImage(null);
            }
            this.imageViewer.setCurrentImageId(this.list.getSelectedIndex());
            if (!this.imageViewer.getImageScale().equals("thumbnail")) {
                this.imageViewer.showLoading();
            }
            this.imageViewer.refreshGuiAfterImageSelection();
            this.imageViewer.updateImage();
        }
    }

    public synchronized void addImageToList(ImagePlus image, String path) {
        try {
            if (this.imageViewer.getImages().size() == 0) {
                for (int i = 0; i < this.imageViewer.getOperationPanel().getOperationTabPanel().getComponents().length; ++i) {
                    this.imageViewer.getOperationPanel().getOperationTabPanel().setEnabledAt(i, true);
                }
                Component[] componentsFromSelectedTab = ((Container)this.imageViewer.getOperationPanel().getOperationTabPanel().getSelectedComponent()).getComponents();
                for (int i = 0; i < componentsFromSelectedTab.length; ++i) {
                    componentsFromSelectedTab[i].setVisible(true);
                }
            }
            ImageHandler imageHandler = new ImageHandler(image, null);
            imageHandler.setPath(path);
            if (this.imageViewer.getImages().size() > 0 && this.imageViewer.getImages().get(this.imageViewer.getCurrentImageId()).getFullSizeImage() != null) {
                this.imageViewer.getImages().get(this.imageViewer.getCurrentImageId()).setFullSizeImage(null);
            }
            this.imageViewer.setCurrentImageId(this.imageViewer.getImages().size());
            this.imageViewer.getImages().add(imageHandler);
            this.listModel.addElement(ImageUtil.getScaledImageIcon(image.getBufferedImage(), 50, 50, this));
            this.list.setSelectedIndex(this.imageViewer.getCurrentImageId());
            this.imageViewer.refreshGuiAfterImageSelection();
            this.imageViewer.updateImage();
        }
        catch (Throwable t) {
            this.imageViewer.showErrorDialog("Error during loading image", t, true);
        }
    }

    public synchronized void initList(ImageHandler imageHandler) {
        try {
            if (this.imageViewer.getImages().size() == 0) {
                for (int i = 0; i < this.imageViewer.getOperationPanel().getOperationTabPanel().getComponents().length; ++i) {
                    this.imageViewer.getOperationPanel().getOperationTabPanel().setEnabledAt(i, true);
                }
                Component[] componentsFromSelectedTab = ((Container)this.imageViewer.getOperationPanel().getOperationTabPanel().getSelectedComponent()).getComponents();
                for (int i = 0; i < componentsFromSelectedTab.length; ++i) {
                    componentsFromSelectedTab[i].setVisible(true);
                }
            }
            this.imageViewer.getImages().add(imageHandler);
            this.listModel.addElement(ImageUtil.getScaledImageIcon(imageHandler.getImage().getBufferedImage(), 50, 50, this));
            if (!this.wasSelected) {
                this.list.revalidate();
                this.revalidate();
                this.imageViewer.setCurrentImageId(0);
                this.imageViewer.refreshGuiAfterImageSelection();
                this.imageViewer.updateImage();
                this.list.setSelectedIndex(0);
                this.wasSelected = true;
            }
        }
        catch (Throwable t) {
            this.imageViewer.showErrorDialog("Error during loading image", t, true);
        }
    }

    public void keyPressed(KeyEvent e) {
        try {
            if (e.getKeyCode() == 127 && this.listModel.size() > 0) {
                this.imageViewer.getImages().remove(this.imageViewer.getCurrentImageId());
                this.listModel.removeElementAt(this.imageViewer.getCurrentImageId());
                if (this.imageViewer.getImages().size() > 0) {
                    if (this.imageViewer.getCurrentImageId() > 0) {
                        this.imageViewer.setCurrentImageId(this.imageViewer.getCurrentImageId() - 1);
                    } else {
                        this.imageViewer.setCurrentImageId(0);
                    }
                    this.imageViewer.refreshGuiAfterImageSelection();
                    this.imageViewer.updateImage();
                } else {
                    this.adjustForEmptyList();
                }
            }
        }
        catch (Throwable t) {
            this.imageViewer.showErrorDialog("Error during removing image", t, true);
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public JList getList() {
        return this.list;
    }

    public void cleanImagesList() {
        this.imageViewer.getImages().clear();
        this.listModel.removeAllElements();
        this.adjustForEmptyList();
        this.wasSelected = false;
    }

    public void adjustForEmptyList() {
        this.imageViewer.setCurrentImageId(0);
        this.imageViewer.cleanImage();
        for (int i = 0; i < this.imageViewer.getOperationPanel().getOperationTabPanel().getComponents().length; ++i) {
            this.imageViewer.getOperationPanel().getOperationTabPanel().setEnabledAt(i, false);
        }
        Component[] componentsFromSelectedTab = ((Container)this.imageViewer.getOperationPanel().getOperationTabPanel().getSelectedComponent()).getComponents();
        for (int i = 0; i < componentsFromSelectedTab.length; ++i) {
            componentsFromSelectedTab[i].setVisible(false);
        }
    }
}

