/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.chunks.ChunkLoadBehaviour;
import java.util.Set;

public class ChunkHelper {
    public static final String IHDR_TEXT = "IHDR";
    public static final String PLTE_TEXT = "PLTE";
    public static final String IDAT_TEXT = "IDAT";
    public static final String IEND_TEXT = "IEND";
    public static final String cHRM_TEXT = "cHRM";
    public static final String gAMA_TEXT = "gAMA";
    public static final String iCCP_TEXT = "iCCP";
    public static final String sBIT_TEXT = "sBIT";
    public static final String sRGB_TEXT = "sRGB";
    public static final String bKGD_TEXT = "bKGD";
    public static final String hIST_TEXT = "hIST";
    public static final String tRNS_TEXT = "tRNS";
    public static final String pHYs_TEXT = "pHYs";
    public static final String sPLT_TEXT = "sPLT";
    public static final String tIME_TEXT = "tIME";
    public static final String iTXt_TEXT = "iTXt";
    public static final String tEXt_TEXT = "tEXt";
    public static final String zTXt_TEXT = "zTXt";
    public static final byte[] IHDR = ChunkHelper.toBytes("IHDR");
    public static final byte[] PLTE = ChunkHelper.toBytes("PLTE");
    public static final byte[] IDAT = ChunkHelper.toBytes("IDAT");
    public static final byte[] IEND = ChunkHelper.toBytes("IEND");
    public static final byte[] cHRM = ChunkHelper.toBytes("cHRM");
    public static final byte[] gAMA = ChunkHelper.toBytes("gAMA");
    public static final byte[] iCCP = ChunkHelper.toBytes("iCCP");
    public static final byte[] sBIT = ChunkHelper.toBytes("sBIT");
    public static final byte[] sRGB = ChunkHelper.toBytes("sRGB");
    public static final byte[] bKGD = ChunkHelper.toBytes("bKGD");
    public static final byte[] hIST = ChunkHelper.toBytes("hIST");
    public static final byte[] tRNS = ChunkHelper.toBytes("tRNS");
    public static final byte[] pHYs = ChunkHelper.toBytes("pHYs");
    public static final byte[] sPLT = ChunkHelper.toBytes("sPLT");
    public static final byte[] tIME = ChunkHelper.toBytes("tIME");
    public static final byte[] iTXt = ChunkHelper.toBytes("iTXt");
    public static final byte[] tEXt = ChunkHelper.toBytes("tEXt");
    public static final byte[] zTXt = ChunkHelper.toBytes("zTXt");
    public static Set<String> KNOWN_CHUNKS_CRITICAL = PngHelper.asSet("IHDR", "PLTE", "IDAT", "IEND");
    public static Set<String> KNOWN_CHUNKS_BEFORE_PLTE = PngHelper.asSet("cHRM", "gAMA", "iCCP", "sBIT", "sRGB");
    public static Set<String> KNOWN_CHUNKS_AFTER_PLTE = PngHelper.asSet("bKGD", "hIST", "tRNS");
    public static Set<String> KNOWN_CHUNKS_BEFORE_IDAT = PngHelper.asSet("pHYs", "sPLT");
    public static Set<String> KNOWN_CHUNKS_ANYWHERE = PngHelper.asSet("tIME", "iTXt", "tEXt", "zTXt");
    public static Set<String> KNOWN_CHUNKS_BEFORE_IDAT_ALL = PngHelper.unionSets(KNOWN_CHUNKS_BEFORE_PLTE, KNOWN_CHUNKS_AFTER_PLTE, KNOWN_CHUNKS_BEFORE_IDAT);
    public static Set<String> KNOWN_CHUNKS_ANCILLARY_ALL = PngHelper.unionSets(KNOWN_CHUNKS_BEFORE_IDAT_ALL, KNOWN_CHUNKS_ANYWHERE);

    public static boolean isKnown(String id) {
        return KNOWN_CHUNKS_CRITICAL.contains(id) || KNOWN_CHUNKS_ANCILLARY_ALL.contains(id);
    }

    public static byte[] toBytes(String x) {
        return x.getBytes(PngHelper.charsetLatin1);
    }

    public static String toString(byte[] x) {
        return new String(x, PngHelper.charsetLatin1);
    }

    public static boolean isCritical(String id) {
        return Character.isUpperCase(id.charAt(0));
    }

    public static boolean isPublic(String id) {
        return Character.isUpperCase(id.charAt(1));
    }

    public static boolean isSafeToCopy(String id) {
        return !Character.isUpperCase(id.charAt(3));
    }

    public static boolean beforeIDAT(String id) {
        return KNOWN_CHUNKS_BEFORE_IDAT_ALL.contains(id);
    }

    public static boolean beforePLTE(String id) {
        return KNOWN_CHUNKS_BEFORE_PLTE.contains(id);
    }

    public static boolean admitsMultiple(String id) {
        return id.equals(sPLT_TEXT) || id.equals(iTXt_TEXT) || id.equals(tEXt_TEXT) || id.equals(zTXt_TEXT);
    }

    public static int posNullByte(byte[] b) {
        int i = 0;
        while (i < b.length) {
            if (b[i] == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean shouldLoad(String id, ChunkLoadBehaviour behav) {
        if (ChunkHelper.isCritical(id)) {
            return true;
        }
        boolean kwown = ChunkHelper.isKnown(id);
        switch (behav) {
            case LOAD_CHUNK_ALWAYS: {
                return true;
            }
            case LOAD_CHUNK_IF_SAFE: {
                return kwown || ChunkHelper.isSafeToCopy(id);
            }
            case LOAD_CHUNK_KNOWN: {
                return kwown;
            }
            case LOAD_CHUNK_NEVER: {
                return false;
            }
        }
        return false;
    }
}

