/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.jboss.vfs.VirtualFile;
import org.reflections.vfs.JBoss6File;
import org.reflections.vfs.Vfs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JBoss6Dir
implements Vfs.Dir {
    private VirtualFile parent;

    public JBoss6Dir(VirtualFile parent) {
        this.parent = parent;
    }

    @Override
    public String getPath() {
        return this.parent.getPathName();
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        return new Iterable<Vfs.File>(){

            @Override
            public Iterator<Vfs.File> iterator() {
                return new AbstractIterator<Vfs.File>(){
                    final Stack<VirtualFile> stack = new Stack();
                    {
                        this.stack.addAll(JBoss6Dir.this.listFiles(JBoss6Dir.this.parent));
                    }

                    protected Vfs.File computeNext() {
                        while (!this.stack.isEmpty()) {
                            VirtualFile file = this.stack.pop();
                            if (file.isDirectory()) {
                                this.stack.addAll(JBoss6Dir.this.listFiles(file));
                                continue;
                            }
                            return new JBoss6File(JBoss6Dir.this.parent, file);
                        }
                        return (Vfs.File)this.endOfData();
                    }
                };
            }
        };
    }

    private List<VirtualFile> listFiles(VirtualFile file) {
        return file.getChildren();
    }

    @Override
    public void close() {
    }
}

