/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.geometry.SpatialPoint;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import loci.common.RandomAccessInputStream;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FlexHelper {
    private static final int FLEX = 65200;
    private static final String SELECT_CHANNELS = "//Arrays/Array/@Name";
    private static final String SELECT_TILE_FOR_IMAGE = "//Images/Image[@BufferNo='%s']/Sublayout/text()";
    private static final String SELECT_FILTER_REF_FOR_IMAGE = "//Images/Image[@BufferNo='%s']/FilterCombinationRef/text()";
    private static final String SELECT_LIGHTS_REF_FOR_IMAGE = "//Images/Image[@BufferNo='%s']/LightSourceCombinationRef/text()";
    private static final String SELECT_EMISSION_FOR_IMAGE = "//FilterCombinations/FilterCombination[@ID='%s']/SliderRef[@ID='%s']";
    private static final String SELECT_LASER_FOR_IMAGE = "//LightSourceCombinations/LightSourceCombination[@ID='%s']/LightSourceRef/@ID";
    private static final String SELECT_EXCITATION_FOR_IMAGE = "//LightSources/LightSource[@ID='%s']/Wavelength/text()";
    private static final String SELECT_TILE_XCOORDS = "//Sublayouts/Sublayout/Field/OffsetX/text()";
    private static final String SELECT_TILE_YCOORDS = "//Sublayouts/Sublayout/Field/OffsetY/text()";
    private final String file;
    private final String metadataXML;
    private final Document metadata;

    public FlexHelper(String file) {
        this.file = file;
        try {
            this.metadataXML = this.readMetadata();
            this.metadata = this.parseXmlDocument(this.metadataXML);
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public int getTileNumber(int imageIdx) {
        String query = String.format(SELECT_TILE_FOR_IMAGE, imageIdx);
        NodeList nodeList = this.selectByXpathQuery(query);
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException("No image can be matched to idx=" + imageIdx);
        }
        String tile = nodeList.item(0).getNodeValue();
        return Integer.parseInt(tile.trim());
    }

    public String getChannelCode(int imageIdx) {
        NodeList nodeList = this.selectByXpathQuery(SELECT_CHANNELS);
        if (imageIdx < 0 || nodeList.getLength() <= imageIdx) {
            throw new IllegalArgumentException("No image can be matched to idx=" + imageIdx);
        }
        return nodeList.item(imageIdx).getNodeValue();
    }

    public String getChannelDescription(int imageIdx) {
        String out = String.valueOf(this.getChannelCode(imageIdx)) + " - Ex:" + this.getExcitationTag(imageIdx) + "nm Em:" + this.getEmissionTag(imageIdx) + "nm";
        return out;
    }

    public String getExpCam(int imageIdx) {
        NodeList nodeList = this.selectByXpathQuery(SELECT_CHANNELS);
        if (imageIdx < 0 || nodeList.getLength() <= imageIdx) {
            throw new IllegalArgumentException("No image can be matched to idx=" + imageIdx);
        }
        return nodeList.item(imageIdx).getNodeValue();
    }

    public String getFilterRef(int imageIdx) {
        String query = String.format(SELECT_FILTER_REF_FOR_IMAGE, imageIdx);
        NodeList nodeList = this.selectByXpathQuery(query);
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException("No image can be matched to idx=" + imageIdx);
        }
        String filterRef = nodeList.item(0).getNodeValue();
        return filterRef.trim();
    }

    public String getLightSRef(int imageIdx) {
        String query = String.format(SELECT_LIGHTS_REF_FOR_IMAGE, imageIdx);
        NodeList nodeList = this.selectByXpathQuery(query);
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException("No image can be matched to idx=" + imageIdx);
        }
        String filterRef = nodeList.item(0).getNodeValue();
        return filterRef.trim();
    }

    public String getCamera(int imageIdx) {
        String expCam = this.getExpCam(imageIdx);
        String cam = "Camera" + expCam.split("Cam")[1];
        return cam.trim();
    }

    public String getEmissionTag(int imageIdx) {
        String query = String.format(SELECT_EMISSION_FOR_IMAGE, this.getFilterRef(imageIdx), this.getCamera(imageIdx));
        NodeList nodeList = this.selectByXpathQuery(query);
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException("No image can be matched to idx=" + imageIdx);
        }
        String emissionTag = nodeList.item(0).getAttributes().getNamedItem("Filter").getNodeValue();
        return emissionTag.trim();
    }

    public String getExcitationTag(int imageIdx) {
        String query = String.format(SELECT_LASER_FOR_IMAGE, this.getLightSRef(imageIdx));
        NodeList nodeList = this.selectByXpathQuery(query);
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException("No image can be matched to idx=" + imageIdx);
        }
        String out = "";
        int i = 0;
        while (i < nodeList.getLength()) {
            out = String.valueOf(out) + this.getWaveLength(nodeList.item(i).getNodeValue()) + ",";
            ++i;
        }
        out = out.substring(0, out.length() - 1);
        return out;
    }

    public String getWaveLength(String laser) {
        String query = String.format(SELECT_EXCITATION_FOR_IMAGE, laser);
        NodeList nodeList = this.selectByXpathQuery(query);
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException("No image can be matched to idx=" + laser);
        }
        String waveLength = nodeList.item(0).getNodeValue();
        return waveLength.trim();
    }

    public Map<Integer, SpatialPoint> getTileCoordinates() {
        HashMap<Integer, SpatialPoint> points = new HashMap<Integer, SpatialPoint>();
        List<Double> xCoords = this.selectDoubleList(SELECT_TILE_XCOORDS);
        List<Double> yCoords = this.selectDoubleList(SELECT_TILE_YCOORDS);
        int i = 0;
        while (i < xCoords.size()) {
            int tile = i + 1;
            SpatialPoint point = new SpatialPoint(xCoords.get(i).doubleValue(), yCoords.get(i).doubleValue());
            points.put(tile, point);
            ++i;
        }
        return points;
    }

    public String getMetadata() {
        return this.metadataXML;
    }

    public NodeList selectByXpathQuery(String xpathQuery) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile(xpathQuery);
            return (NodeList)expr.evaluate(this.metadata, XPathConstants.NODESET);
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private List<Double> selectDoubleList(String query) {
        NodeList nodeList = this.selectByXpathQuery(query);
        ArrayList<Double> result = new ArrayList<Double>();
        int i = 0;
        while (i < nodeList.getLength()) {
            String stringValue = nodeList.item(i).getNodeValue();
            Double doubleValue = Double.parseDouble(stringValue.trim());
            result.add(doubleValue);
            ++i;
        }
        return result;
    }

    private String readMetadata() throws Exception {
        RandomAccessInputStream in = new RandomAccessInputStream(this.file);
        try {
            TiffParser tiffParser = new TiffParser(in);
            IFDList ifds = tiffParser.getIFDs();
            if (ifds != null && ifds.get(0) != null) {
                String string = ((IFD)ifds.get(0)).getIFDStringValue(65200);
                return string;
            }
            throw new IllegalArgumentException("Cannot parse Flex XML metadata from file " + this.file);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private Document parseXmlDocument(String value) {
        DocumentBuilderFactory dBF = DocumentBuilderFactory.newInstance();
        dBF.setNamespaceAware(true);
        InputSource is = new InputSource(new StringReader(value));
        try {
            return dBF.newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to parse FLEX metadata :\n\n%s\n\nisn't a well formed XML document. %s", value, e.getMessage());
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

